/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.Component;
import org.apache.camel.component.iec60870.AbstractConnectionMultiplexor;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.client.ClientOptions;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions;

public abstract class AbstractIecEndpoint<T extends AbstractConnectionMultiplexor>
extends DefaultEndpoint {
    @UriPath(name="uriPath")
    @Metadata(required="true")
    private final ObjectAddress address;
    @UriParam
    private ClientOptions connectionOptions;
    @UriParam
    private ProtocolOptions protocolOptions;
    @UriParam
    private DataModuleOptions dataModuleOptions;
    @UriParam(label="id")
    private String connectionId;
    private final T connection;
    private final AtomicReference<AbstractConnectionMultiplexor.Handle> connectionHandle = new AtomicReference();

    public AbstractIecEndpoint(String uri, DefaultComponent component, T connection, ObjectAddress address) {
        super(uri, (Component)component);
        this.connection = (AbstractConnectionMultiplexor)Objects.requireNonNull(connection);
        this.address = Objects.requireNonNull(address);
    }

    public ObjectAddress getAddress() {
        return this.address;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connectionHandle.set(((AbstractConnectionMultiplexor)this.connection).register());
    }

    protected void doStop() throws Exception {
        AbstractConnectionMultiplexor.Handle connectionHandle = this.connectionHandle.getAndSet(null);
        if (connectionHandle != null) {
            connectionHandle.unregister();
        }
        super.doStop();
    }

    protected T getConnection() {
        return this.connection;
    }

    public boolean isSingleton() {
        return true;
    }
}

