/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.camel.RuntimeCamelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionMultiplexor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConnectionMultiplexor.class);
    private final Set<HandleImplementation> handles = new CopyOnWriteArraySet<HandleImplementation>();

    public synchronized Handle register() throws Exception {
        HandleImplementation handle = new HandleImplementation();
        boolean needStart = this.handles.isEmpty();
        this.handles.add(handle);
        if (needStart) {
            LOG.info("Calling performStart()");
            this.performStart();
        }
        return handle;
    }

    private synchronized void unregister(HandleImplementation handle) throws Exception {
        if (!this.handles.remove(handle)) {
            return;
        }
        if (this.handles.isEmpty()) {
            LOG.info("Calling performStop()");
            this.performStop();
        }
    }

    public synchronized void dispose() {
        LOG.info("Disposing");
        if (this.handles.isEmpty()) {
            LOG.debug("Disposing - not started");
            return;
        }
        LOG.debug("Disposing - calling performStop()");
        this.handles.clear();
        try {
            this.performStop();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to stop on dispose", (Throwable)e);
        }
    }

    protected abstract void performStart() throws Exception;

    protected abstract void performStop() throws Exception;

    private final class HandleImplementation
    implements Handle {
        private HandleImplementation() {
        }

        @Override
        public void unregister() throws Exception {
            AbstractConnectionMultiplexor.this.unregister(this);
        }
    }

    public static interface Handle {
        public void unregister() throws Exception;
    }
}

