/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.server;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.iec60870.server.ServerEndpoint;
import org.apache.camel.component.iec60870.server.ServerInstance;
import org.apache.camel.support.DefaultProducer;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

public class ServerProducer
extends DefaultProducer {
    private final ServerEndpoint endpoint;
    private final ServerInstance server;

    public ServerProducer(ServerEndpoint endpoint, ServerInstance server) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.server = server;
    }

    public void process(Exchange exchange) throws Exception {
        Value<?> value = this.mapToCommand(exchange);
        this.server.notifyValue(this.endpoint.getAddress(), value);
    }

    private Value<?> mapToCommand(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (body instanceof Value) {
            return (Value)body;
        }
        if (body instanceof Float || body instanceof Double) {
            return Value.ok((Object)Float.valueOf(((Number)body).floatValue()));
        }
        if (body instanceof Boolean) {
            return Value.ok((Object)((Boolean)body));
        }
        if (body instanceof Short || body instanceof Byte || body instanceof Integer || body instanceof Long) {
            return this.convertToShort(((Number)body).longValue());
        }
        throw new IllegalArgumentException("Unable to map body to a value: " + body);
    }

    private Value<?> convertToShort(long value) {
        if (value < -32768L || value > 32767L) {
            throw new IllegalArgumentException(String.format("Value must be between %s and %s", (short)Short.MIN_VALUE, (short)Short.MAX_VALUE));
        }
        return Value.ok((Object)((short)value));
    }
}

