/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ignite.AbstractIgniteComponent;
import org.apache.camel.component.ignite.AbstractIgniteEndpoint;
import org.apache.camel.component.ignite.cache.IgniteCacheEndpoint;
import org.apache.camel.component.ignite.compute.IgniteComputeEndpoint;
import org.apache.camel.component.ignite.events.IgniteEventsEndpoint;
import org.apache.camel.component.ignite.idgen.IgniteIdGenEndpoint;
import org.apache.camel.component.ignite.messaging.IgniteMessagingEndpoint;
import org.apache.camel.component.ignite.queue.IgniteQueueEndpoint;
import org.apache.camel.component.ignite.set.IgniteSetEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.ignite.Ignite;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class IgniteComponent
extends AbstractIgniteComponent {
    private static final Logger LOG = LoggerFactory.getLogger(IgniteComponent.class);

    public static IgniteComponent fromIgnite(Ignite ignite) {
        IgniteComponent answer = new IgniteComponent();
        answer.setIgnite(ignite);
        return answer;
    }

    public static IgniteComponent fromConfiguration(IgniteConfiguration configuration) {
        IgniteComponent answer = new IgniteComponent();
        answer.setIgniteConfiguration(configuration);
        return answer;
    }

    public static IgniteComponent fromInputStream(InputStream inputStream) {
        IgniteComponent answer = new IgniteComponent();
        answer.setConfigurationResource(inputStream);
        return answer;
    }

    public static IgniteComponent fromUrl(URL url) {
        IgniteComponent answer = new IgniteComponent();
        answer.setConfigurationResource(url);
        return answer;
    }

    public static IgniteComponent fromLocation(String location) {
        IgniteComponent answer = new IgniteComponent();
        answer.setConfigurationResource(location);
        return answer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"Camel Context");
        AbstractIgniteEndpoint answer = null;
        URI remainingUri = new URI(URISupport.normalizeUri((String)remaining));
        String scheme = remainingUri.getScheme();
        LOG.warn("The scheme syntax 'ignite:{}' has been deprecated. Use 'ignite-{}' instead.", (Object)scheme, (Object)scheme);
        switch (scheme) {
            case "cache": {
                answer = new IgniteCacheEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "compute": {
                answer = new IgniteComputeEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "messaging": {
                answer = new IgniteMessagingEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "events": {
                answer = new IgniteEventsEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "set": {
                answer = new IgniteSetEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "idgen": {
                answer = new IgniteIdGenEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "queue": {
                answer = new IgniteQueueEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            default: {
                throw new MalformedURLException("An invalid Ignite endpoint URI was provided. Please check that it starts with: ignite:[cache/compute/messaging/...]:...");
            }
        }
        this.setProperties((Object)answer, parameters);
        return answer;
    }
}

