/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ignite.IgniteHelper;
import org.apache.camel.component.ignite.cache.IgniteCacheEndpoint;
import org.apache.camel.component.ignite.cache.IgniteCacheOperation;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.MessageHelper;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;

public class IgniteCacheProducer
extends DefaultAsyncProducer {
    private IgniteCache<Object, Object> cache;
    private IgniteCacheEndpoint endpoint;

    public IgniteCacheProducer(IgniteCacheEndpoint endpoint, IgniteCache<Object, Object> igniteCache) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.cache = igniteCache;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message in = exchange.getIn();
        Message out = exchange.getOut();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)out, (boolean)true);
        switch (this.cacheOperationFor(exchange)) {
            case GET: {
                this.doGet(in, out);
                break;
            }
            case PUT: {
                this.doPut(in, out);
                break;
            }
            case QUERY: {
                this.doQuery(in, out, exchange);
                break;
            }
            case REMOVE: {
                this.doRemove(in, out);
                break;
            }
            case CLEAR: {
                this.doClear(in, out);
                break;
            }
            case SIZE: {
                this.doSize(in, out);
                break;
            }
            case REBALANCE: {
                this.doRebalance(in, out);
                break;
            }
        }
        return true;
    }

    private void doGet(Message in, Message out) {
        Object cacheKey = this.cacheKey(in);
        if (cacheKey instanceof Set && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
            out.setBody((Object)this.cache.getAll((Set)cacheKey));
        } else {
            out.setBody(this.cache.get(cacheKey));
        }
    }

    private void doPut(Message in, Message out) {
        Map map = (Map)in.getBody(Map.class);
        if (map != null) {
            this.cache.putAll(map);
            return;
        }
        Object cacheKey = in.getHeader("CamelIgniteCacheKey");
        if (cacheKey == null) {
            throw new RuntimeCamelException("Cache PUT operation requires the cache key in the CamelIgniteCacheKey header, or a payload of type Map.");
        }
        this.cache.put(cacheKey, in.getBody());
        IgniteHelper.maybePropagateIncomingBody(this.endpoint, in, out);
    }

    private void doQuery(Message in, Message out, Exchange exchange) {
        Query query = (Query)in.getHeader("CamelIgniteCacheQuery", Query.class);
        if (query == null) {
            try {
                query = (Query)in.getMandatoryBody(Query.class);
            }
            catch (InvalidPayloadException e) {
                exchange.setException((Throwable)e);
                return;
            }
        }
        final QueryCursor cursor = this.cache.query(query);
        out.setBody((Object)cursor.iterator());
        exchange.addOnCompletion(new Synchronization(){

            public void onFailure(Exchange exchange) {
                cursor.close();
            }

            public void onComplete(Exchange exchange) {
                cursor.close();
            }
        });
    }

    private void doRemove(Message in, Message out) {
        Object cacheKey = this.cacheKey(in);
        if (cacheKey instanceof Set && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
            this.cache.removeAll((Set)cacheKey);
        } else {
            this.cache.remove(cacheKey);
        }
        IgniteHelper.maybePropagateIncomingBody(this.endpoint, in, out);
    }

    private void doClear(Message in, Message out) {
        this.cache.removeAll();
        IgniteHelper.maybePropagateIncomingBody(this.endpoint, in, out);
    }

    private void doRebalance(Message in, Message out) {
        this.cache.rebalance().get();
        IgniteHelper.maybePropagateIncomingBody(this.endpoint, in, out);
    }

    private void doSize(Message in, Message out) {
        Object peekMode = in.getHeader("CamelIgniteCachePeekMode", (Object)this.endpoint.getCachePeekMode());
        Integer result = null;
        if (peekMode instanceof Collection) {
            result = this.cache.size(((Collection)peekMode).toArray(new CachePeekMode[0]));
        } else if (peekMode instanceof CachePeekMode) {
            result = this.cache.size(new CachePeekMode[]{(CachePeekMode)peekMode});
        }
        out.setBody(result);
    }

    private Object cacheKey(Message msg) {
        Object cacheKey = msg.getHeader("CamelIgniteCacheKey");
        if (cacheKey == null) {
            cacheKey = msg.getBody();
        }
        return cacheKey;
    }

    private IgniteCacheOperation cacheOperationFor(Exchange exchange) {
        return (IgniteCacheOperation)((Object)exchange.getIn().getHeader("CamelIgniteCacheOperation", (Object)this.endpoint.getOperation(), IgniteCacheOperation.class));
    }
}

