/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ignite.queue.IgniteQueueEndpoint;
import org.apache.camel.component.ignite.queue.IgniteQueueOperation;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.ignite.IgniteQueue;

public class IgniteQueueProducer
extends DefaultAsyncProducer {
    private IgniteQueueEndpoint endpoint;
    private IgniteQueue<Object> queue;

    public IgniteQueueProducer(IgniteQueueEndpoint endpoint, IgniteQueue<Object> queue) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.queue = queue;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message in = exchange.getIn();
        Message out = exchange.getOut();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)out, (boolean)true);
        Object body = in.getBody();
        switch (this.queueOperationFor(exchange)) {
            case ADD: {
                if (Collection.class.isAssignableFrom(body.getClass()) && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
                    out.setBody((Object)this.queue.addAll((Collection)body));
                    break;
                }
                out.setBody((Object)this.queue.add(body));
                break;
            }
            case CONTAINS: {
                if (Collection.class.isAssignableFrom(body.getClass()) && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
                    out.setBody((Object)this.queue.containsAll((Collection)body));
                    break;
                }
                out.setBody((Object)this.queue.contains(body));
                break;
            }
            case SIZE: {
                out.setBody((Object)this.queue.size());
                break;
            }
            case REMOVE: {
                if (Collection.class.isAssignableFrom(body.getClass()) && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
                    out.setBody((Object)this.queue.removeAll((Collection)body));
                    break;
                }
                out.setBody((Object)this.queue.remove(body));
                break;
            }
            case CLEAR: {
                if (this.endpoint.isPropagateIncomingBodyIfNoReturnValue()) {
                    out.setBody(body);
                }
                this.queue.clear();
                break;
            }
            case ITERATOR: {
                Iterator iterator = this.queue.iterator();
                out.setBody((Object)iterator);
                break;
            }
            case ARRAY: {
                out.setBody((Object)this.queue.toArray());
                break;
            }
            case RETAIN_ALL: {
                if (Collection.class.isAssignableFrom(body.getClass())) {
                    out.setBody((Object)this.queue.retainAll((Collection)body));
                    break;
                }
                out.setBody((Object)this.queue.retainAll(Collections.singleton(body)));
                break;
            }
            case DRAIN: {
                Integer maxElements = (Integer)in.getHeader("CamelIgniteQueueMaxElements", Integer.class);
                Collection col = null;
                col = body != null && Collection.class.isAssignableFrom(body.getClass()) ? (Collection)body : (maxElements != null ? new ArrayList(maxElements) : new ArrayList());
                int transferred = -1;
                transferred = maxElements == null ? this.queue.drainTo(col) : this.queue.drainTo(col, maxElements.intValue());
                out.setBody(col);
                out.setHeader("CamelIgniteQueueTransferredCount", (Object)transferred);
                break;
            }
            case ELEMENT: {
                out.setBody(this.queue.element());
                break;
            }
            case OFFER: {
                Long millis = (Long)in.getHeader("CamelIgniteQueueTimeoutMillis", (Object)this.endpoint.getTimeoutMillis(), Long.class);
                boolean result = millis == null ? this.queue.offer(body) : this.queue.offer(body, millis.longValue(), TimeUnit.MILLISECONDS);
                out.setBody((Object)result);
                break;
            }
            case PEEK: {
                out.setBody(this.queue.peek());
                break;
            }
            case POLL: {
                Long millis = (Long)in.getHeader("CamelIgniteQueueTimeoutMillis", (Object)this.endpoint.getTimeoutMillis(), Long.class);
                out.setBody(millis == null ? this.queue.poll() : this.queue.poll(millis.longValue(), TimeUnit.MILLISECONDS));
                break;
            }
            case PUT: {
                if (this.endpoint.isPropagateIncomingBodyIfNoReturnValue()) {
                    out.setBody(in.getBody());
                }
                this.queue.put(body);
                break;
            }
            case TAKE: {
                out.setBody(this.queue.take());
                break;
            }
            default: {
                exchange.setException((Throwable)new UnsupportedOperationException("Operation not supported by Ignite Queue producer."));
            }
        }
        callback.done(false);
        return false;
    }

    private IgniteQueueOperation queueOperationFor(Exchange exchange) {
        return (IgniteQueueOperation)((Object)exchange.getIn().getHeader("CamelIgniteQueueOperation", (Object)this.endpoint.getOperation(), IgniteQueueOperation.class));
    }
}

