/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.cluster;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InfinispanClusterView
extends AbstractCamelClusterView {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanClusterView.class);

    protected InfinispanClusterView(CamelClusterService cluster, String namespace) {
        super(cluster, namespace);
    }

    protected abstract boolean isLeader(String var1);

    protected final class ClusterMember
    implements CamelClusterMember {
        private final String id;

        public ClusterMember(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public boolean isLeader() {
            return InfinispanClusterView.this.isLeader(this.id);
        }

        public boolean isLocal() {
            if (this.id == null) {
                return false;
            }
            return Objects.equals(this.id, InfinispanClusterView.this.getLocalMember().getId());
        }

        public String toString() {
            return "ClusterMember{id='" + this.id + "'}";
        }
    }

    protected final class LocalMember
    implements CamelClusterMember {
        private final AtomicBoolean leader = new AtomicBoolean();
        private final String id;

        public LocalMember(String id) {
            this.id = id;
        }

        public void setLeader(boolean master) {
            if (master && this.leader.compareAndSet(false, true)) {
                LOGGER.debug("Leadership taken for id: {}", (Object)this.id);
                InfinispanClusterView.this.fireLeadershipChangedEvent(this);
                return;
            }
            if (!master && this.leader.compareAndSet(true, false)) {
                LOGGER.debug("Leadership lost for id: {}", (Object)this.id);
                InfinispanClusterView.this.fireLeadershipChangedEvent(InfinispanClusterView.this.getLeader().orElse(null));
                return;
            }
        }

        public boolean isLeader() {
            return this.leader.get();
        }

        public boolean isLocal() {
            return true;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return "LocalMember{leader=" + this.leader + "}";
        }
    }
}

