/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import java.util.function.Supplier;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.infinispan.InfinispanIdempotentRepository;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConfiguration;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedManager;
import org.apache.camel.util.function.Suppliers;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.manager.EmbeddedCacheManager;

@ManagedResource(description="Infinispan Embedded message id repository")
public class InfinispanEmbeddedIdempotentRepository
extends InfinispanIdempotentRepository {
    private final String cacheName;
    private final Supplier<BasicCache<String, Boolean>> cache;
    private InfinispanEmbeddedConfiguration configuration;
    private InfinispanEmbeddedManager manager;

    public InfinispanEmbeddedIdempotentRepository(String cacheName) {
        this.cacheName = cacheName;
        this.cache = Suppliers.memorize(() -> this.manager.getCache(this.getCacheName()));
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configuration == null) {
            this.configuration = new InfinispanEmbeddedConfiguration();
        }
        this.manager = new InfinispanEmbeddedManager(this.configuration);
        this.manager.setCamelContext(this.getCamelContext());
        this.manager.start();
    }

    protected void doShutdown() throws Exception {
        this.manager.shutdown();
        super.doShutdown();
    }

    protected BasicCache<String, Boolean> getCache() {
        return this.cache.get();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public InfinispanEmbeddedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(InfinispanEmbeddedConfiguration configuration) {
        this.configuration = configuration;
    }

    public InfinispanEmbeddedManager getManager() {
        return this.manager;
    }

    public void setManager(InfinispanEmbeddedManager manager) {
        this.manager = manager;
    }

    public EmbeddedCacheManager getCacheContainer() {
        return this.configuration != null ? this.configuration.getCacheContainer() : null;
    }

    public void setCacheContainer(EmbeddedCacheManager cacheContainer) {
        if (this.configuration == null) {
            this.configuration = new InfinispanEmbeddedConfiguration();
        }
        this.configuration.setCacheContainer(cacheContainer);
    }
}

