/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import java.util.function.Supplier;
import org.apache.camel.component.infinispan.InfinispanAggregationRepository;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConfiguration;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedManager;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;
import org.infinispan.commons.api.BasicCache;

public class InfinispanEmbeddedAggregationRepository
extends InfinispanAggregationRepository {
    private final Supplier<BasicCache<String, DefaultExchangeHolder>> cache = Suppliers.memorize(() -> this.manager.getCache(this.getCacheName()));
    private InfinispanEmbeddedConfiguration configuration;
    private InfinispanEmbeddedManager manager;

    public InfinispanEmbeddedAggregationRepository(String cacheName) {
        super(cacheName);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (ObjectHelper.isEmpty((Object)this.configuration)) {
            this.configuration = new InfinispanEmbeddedConfiguration();
        }
        if (ObjectHelper.isEmpty((Object)((Object)this.manager))) {
            this.manager = new InfinispanEmbeddedManager(this.configuration);
        }
        this.manager.setCamelContext(this.getCamelContext());
        ServiceHelper.startService((Object)((Object)this.manager));
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)((Object)this.manager));
    }

    protected BasicCache<String, DefaultExchangeHolder> getCache() {
        return this.cache.get();
    }

    public InfinispanEmbeddedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(InfinispanEmbeddedConfiguration configuration) {
        this.configuration = configuration;
    }
}

