/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.Set;
import org.apache.camel.component.infinispan.InfinispanEventListener;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientCacheFailover;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.client.hotrod.event.ClientEvent;

@ClientListener
public class InfinispanRemoteEventListener
extends InfinispanEventListener<ClientEvent.Type> {
    public InfinispanRemoteEventListener(Set<ClientEvent.Type> events) {
        super(events);
    }

    @ClientCacheEntryCreated
    public void processEvent(ClientCacheEntryCreatedEvent<Object> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), this.getCacheName(), event.getKey(), null, e -> {
                e.getMessage().setHeader("CamelInfinispanEntryVersion", (Object)event.getVersion());
                e.getMessage().setHeader("CamelInfinispanCommandRetried", (Object)event.isCommandRetried());
            });
        }
    }

    @ClientCacheEntryModified
    public void processEvent(ClientCacheEntryModifiedEvent<Object> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), this.getCacheName(), event.getKey(), null, e -> {
                e.getMessage().setHeader("CamelInfinispanEntryVersion", (Object)event.getVersion());
                e.getMessage().setHeader("CamelInfinispanCommandRetried", (Object)event.isCommandRetried());
            });
        }
    }

    @ClientCacheEntryRemoved
    public void processEvent(ClientCacheEntryRemovedEvent<Object> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), this.getCacheName(), event.getKey(), null, e -> e.getMessage().setHeader("CamelInfinispanCommandRetried", (Object)event.isCommandRetried()));
        }
    }

    @ClientCacheFailover
    public void processEvent(ClientCacheFailoverEvent event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), this.getCacheName(), null, null, null);
        }
    }

    @ClientCacheEntryExpired
    public void processEvent(ClientCacheEntryExpiredEvent<Object> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), this.getCacheName(), event.getKey(), null, null);
        }
    }
}

