/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.function.Supplier;
import org.apache.camel.Service;
import org.apache.camel.component.infinispan.InfinispanAggregationRepository;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteManager;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteUtil;
import org.apache.camel.component.infinispan.remote.protostream.DefaultExchangeHolderContextInitializer;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.function.Suppliers;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.protostream.SerializationContextInitializer;

public class InfinispanRemoteAggregationRepository
extends InfinispanAggregationRepository {
    private final Supplier<BasicCache<String, DefaultExchangeHolder>> cache = Suppliers.memorize(() -> InfinispanRemoteUtil.getCacheWithFlags(this.manager, this.getCacheName(), Flag.FORCE_RETURN_VALUE));
    private InfinispanRemoteConfiguration configuration;
    private InfinispanRemoteManager manager;

    public InfinispanRemoteAggregationRepository(String cacheName) {
        super(cacheName);
    }

    protected void doStart() throws Exception {
        InfinispanRemoteConfiguration conf;
        super.doStart();
        InfinispanRemoteConfiguration infinispanRemoteConfiguration = conf = this.configuration != null ? this.configuration : new InfinispanRemoteConfiguration();
        if (conf.getCacheContainerConfiguration() == null) {
            conf.setCacheContainerConfiguration(new ConfigurationBuilder().addContextInitializer((SerializationContextInitializer)new DefaultExchangeHolderContextInitializer()).build());
        } else {
            conf.setCacheContainerConfiguration(new ConfigurationBuilder().read(conf.getCacheContainerConfiguration(), Combine.DEFAULT).addContextInitializer((SerializationContextInitializer)new DefaultExchangeHolderContextInitializer()).build());
        }
        this.manager = new InfinispanRemoteManager(conf);
        this.manager.setCamelContext(this.getCamelContext());
        ServiceHelper.startService((Service)this.manager);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Service)this.manager);
    }

    protected BasicCache<String, DefaultExchangeHolder> getCache() {
        return this.cache.get();
    }

    public InfinispanRemoteConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(InfinispanRemoteConfiguration configuration) {
        this.configuration = configuration;
    }
}

