/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb2;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.WriteApi;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.influxdb2.CamelInfluxDb2Exception;
import org.apache.camel.component.influxdb2.InfluxDb2Endpoint;
import org.apache.camel.component.influxdb2.data.Measurement;
import org.apache.camel.component.influxdb2.data.Measurements;
import org.apache.camel.component.influxdb2.data.Points;
import org.apache.camel.component.influxdb2.data.Record;
import org.apache.camel.component.influxdb2.data.Records;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDb2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDb2Producer.class);
    InfluxDb2Endpoint endpoint;
    InfluxDBClient connection;
    WriteApi writeApi;

    public InfluxDb2Producer(InfluxDb2Endpoint endpoint) {
        super((Endpoint)endpoint);
        this.connection = endpoint.getInfluxDBClient();
        this.endpoint = endpoint;
        this.writeApi = this.connection.makeWriteApi();
    }

    public void process(Exchange exchange) throws Exception {
        String orgName = this.calculateOrgName(exchange);
        String bucketName = this.calculateBucketName(exchange);
        WritePrecision writePrecision = this.calculateWritePrecision(exchange);
        switch (this.endpoint.getOperation()) {
            case INSERT: {
                this.doInsert(exchange, orgName, bucketName, writePrecision);
                break;
            }
            case PING: {
                this.doPing(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("The operation " + this.endpoint.getOperation() + " is not supported");
            }
        }
    }

    private void doInsert(Exchange exchange, String orgName, String bucketName, WritePrecision writePrecision) throws InvalidPayloadException {
        Object body = exchange.getIn().getBody();
        if (body instanceof Point) {
            this.insertPoint(exchange, orgName, bucketName);
        } else if (body instanceof Measurement) {
            this.insertMeasurement(exchange, orgName, bucketName, writePrecision);
        } else if (body instanceof Record) {
            this.insertRecord(exchange, orgName, bucketName, writePrecision);
        } else if (body instanceof Points) {
            this.insertPoints(exchange, orgName, bucketName);
        } else if (body instanceof Measurements) {
            this.insertMeasurements(exchange, orgName, bucketName, writePrecision);
        } else if (body instanceof Records) {
            this.insertRecords(exchange, orgName, bucketName, writePrecision);
        } else {
            this.insertPoint(exchange, orgName, bucketName);
        }
    }

    private void insertPoint(Exchange exchange, String orgName, String bucketName) throws InvalidPayloadException {
        Point point = (Point)exchange.getIn().getMandatoryBody(Point.class);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing point {}", (Object)point.toLineProtocol());
            }
            this.writeApi.writePoint(bucketName, orgName, point);
        }
        catch (Exception ex) {
            exchange.setException((Throwable)new CamelInfluxDb2Exception(ex));
        }
    }

    private void insertMeasurement(Exchange exchange, String orgName, String bucketName, WritePrecision writePrecision) throws InvalidPayloadException {
        Measurement measurement = (Measurement)exchange.getIn().getMandatoryBody(Measurement.class);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing measurement {}", (Object)measurement);
            }
            this.writeApi.writeMeasurement(bucketName, orgName, writePrecision, measurement.getInfluxMeasurement());
        }
        catch (Exception ex) {
            exchange.setException((Throwable)new CamelInfluxDb2Exception(ex));
        }
    }

    private void insertRecord(Exchange exchange, String orgName, String bucketName, WritePrecision writePrecision) throws InvalidPayloadException {
        Record recordObj = (Record)exchange.getIn().getMandatoryBody(Record.class);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing record {}", (Object)recordObj);
            }
            this.writeApi.writeRecord(bucketName, orgName, writePrecision, recordObj.getInfluxRecord());
        }
        catch (Exception ex) {
            exchange.setException((Throwable)new CamelInfluxDb2Exception(ex));
        }
    }

    private void insertPoints(Exchange exchange, String orgName, String bucketName) throws InvalidPayloadException {
        Points points = (Points)exchange.getIn().getMandatoryBody(Points.class);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing points {}", (Object)points);
            }
            this.writeApi.writePoints(bucketName, orgName, points.getInfluxPoints());
        }
        catch (Exception ex) {
            exchange.setException((Throwable)new CamelInfluxDb2Exception(ex));
        }
    }

    private void insertMeasurements(Exchange exchange, String orgName, String bucketName, WritePrecision writePrecision) throws InvalidPayloadException {
        Measurements measurements = (Measurements)exchange.getIn().getMandatoryBody(Measurements.class);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing measurements {}", (Object)measurements);
            }
            this.writeApi.writeMeasurements(bucketName, orgName, writePrecision, measurements.getInfluxMeasurements());
        }
        catch (Exception ex) {
            exchange.setException((Throwable)new CamelInfluxDb2Exception(ex));
        }
    }

    private void insertRecords(Exchange exchange, String orgName, String bucketName, WritePrecision writePrecision) throws InvalidPayloadException {
        Records records = (Records)exchange.getIn().getMandatoryBody(Records.class);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing records {}", (Object)records);
            }
            this.writeApi.writeRecords(bucketName, orgName, writePrecision, records.getInfluxRecords());
        }
        catch (Exception ex) {
            exchange.setException((Throwable)new CamelInfluxDb2Exception(ex));
        }
    }

    private void doPing(Exchange exchange) {
        Boolean result = this.connection.ping();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getMessage().setBody((Object)result);
    }

    private String calculateOrgName(Exchange exchange) {
        String orgName = (String)exchange.getIn().getHeader("CamelInfluxDB2Org", String.class);
        if (ObjectHelper.isNotEmpty((String)orgName)) {
            return orgName;
        }
        return this.endpoint.getOrg();
    }

    private String calculateBucketName(Exchange exchange) {
        String bucketName = (String)exchange.getIn().getHeader("CamelInfluxDB2Bucket", String.class);
        if (ObjectHelper.isNotEmpty((String)bucketName)) {
            return bucketName;
        }
        return this.endpoint.getBucket();
    }

    private WritePrecision calculateWritePrecision(Exchange exchange) {
        WritePrecision precision = (WritePrecision)exchange.getIn().getHeader("CamelInfluxDB2WritePrecision", WritePrecision.class);
        if (ObjectHelper.isNotEmpty((Object)precision)) {
            return precision;
        }
        return this.endpoint.getWritePrecision();
    }
}

