/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.irc.IrcConfiguration;
import org.apache.camel.component.irc.IrcEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.ssl.SSLIRCConnection;

public class IrcComponent
extends DefaultComponent {
    private static final transient Log LOG = LogFactory.getLog(IrcComponent.class);
    private IrcConfiguration configuration;
    private final Map<String, IRCConnection> connectionCache = new HashMap<String, IRCConnection>();

    public IrcComponent() {
        this.configuration = new IrcConfiguration();
    }

    public IrcComponent(IrcConfiguration configuration) {
        this.configuration = configuration;
    }

    public IrcComponent(CamelContext context) {
        super(context);
        this.configuration = new IrcConfiguration();
    }

    protected IrcEndpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        IrcConfiguration config = this.getConfiguration().copy();
        config.configure(uri);
        IrcEndpoint endpoint = new IrcEndpoint(uri, this, config);
        this.setProperties(endpoint.getConfiguration(), parameters);
        return endpoint;
    }

    public synchronized IRCConnection getIRCConnection(IrcConfiguration configuration) {
        IRCConnection connection;
        if (this.connectionCache.containsKey(configuration.getCacheKey())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Returning Cached Connection to " + configuration.getHostname() + " " + configuration.getTarget()));
            }
            connection = this.connectionCache.get(configuration.getCacheKey());
        } else {
            connection = this.createConnection(configuration);
            this.connectionCache.put(configuration.getCacheKey(), connection);
        }
        return connection;
    }

    protected IRCConnection createConnection(IrcConfiguration configuration) {
        IRCConnection conn = null;
        if (configuration.getUsingSSL()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating SSL Connection to " + configuration.getHostname() + " destination: " + configuration.getTarget() + " nick: " + configuration.getNickname() + " user: " + configuration.getUsername()));
            }
            SSLIRCConnection sconn = new SSLIRCConnection(configuration.getHostname(), configuration.getPorts(), configuration.getPassword(), configuration.getNickname(), configuration.getUsername(), configuration.getRealname());
            sconn.addTrustManager(configuration.getTrustManager());
            conn = sconn;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating Connection to " + configuration.getHostname() + " destination: " + configuration.getTarget() + " nick: " + configuration.getNickname() + " user: " + configuration.getUsername()));
            }
            conn = new IRCConnection(configuration.getHostname(), configuration.getPorts(), configuration.getPassword(), configuration.getNickname(), configuration.getUsername(), configuration.getRealname());
        }
        conn.setEncoding("UTF-8");
        conn.setColors(configuration.isColors());
        conn.setPong(true);
        try {
            conn.connect();
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        return conn;
    }

    public void closeConnection(String key, IRCConnection connection) {
        try {
            connection.doQuit();
            connection.close();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error during closing connection.", (Throwable)e);
        }
    }

    protected synchronized void doStop() throws Exception {
        HashMap<String, IRCConnection> map = new HashMap<String, IRCConnection>(this.connectionCache);
        this.connectionCache.clear();
        for (Map.Entry entry : map.entrySet()) {
            this.closeConnection((String)entry.getKey(), (IRCConnection)entry.getValue());
        }
        super.doStop();
    }

    public IrcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IrcConfiguration configuration) {
        this.configuration = configuration;
    }
}

