/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.irc.IrcBinding;
import org.apache.camel.component.irc.IrcComponent;
import org.apache.camel.component.irc.IrcConfiguration;
import org.apache.camel.component.irc.IrcConsumer;
import org.apache.camel.component.irc.IrcMessage;
import org.apache.camel.component.irc.IrcProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;

public class IrcEndpoint
extends DefaultEndpoint {
    private static final transient Log LOG = LogFactory.getLog(IrcEndpoint.class);
    private IrcBinding binding;
    private IrcConfiguration configuration;
    private IrcComponent component;

    public IrcEndpoint(String endpointUri, IrcComponent component, IrcConfiguration configuration) {
        super(endpointUri, (Component)component);
        this.component = component;
        this.configuration = configuration;
    }

    public boolean isSingleton() {
        return true;
    }

    public Exchange createExchange(ExchangePattern pattern) {
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, pattern);
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        return exchange;
    }

    public Exchange createOnPrivmsgExchange(String target, IRCUser user, String msg) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("PRIVMSG", target, user, msg));
        return exchange;
    }

    public Exchange createOnNickExchange(IRCUser user, String newNick) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("NICK", user, newNick));
        return exchange;
    }

    public Exchange createOnQuitExchange(IRCUser user, String msg) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("QUIT", user, msg));
        return exchange;
    }

    public Exchange createOnJoinExchange(String channel, IRCUser user) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("JOIN", channel, user));
        return exchange;
    }

    public Exchange createOnKickExchange(String channel, IRCUser user, String whoWasKickedNick, String msg) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("KICK", channel, user, whoWasKickedNick, msg));
        return exchange;
    }

    public Exchange createOnModeExchange(String channel, IRCUser user, IRCModeParser modeParser) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("MODE", channel, user, modeParser.getLine()));
        return exchange;
    }

    public Exchange createOnPartExchange(String channel, IRCUser user, String msg) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("PART", channel, user, msg));
        return exchange;
    }

    public Exchange createOnReplyExchange(int num, String value, String msg) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("REPLY", num, value, msg));
        return exchange;
    }

    public Exchange createOnTopicExchange(String channel, IRCUser user, String topic) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("TOPIC", channel, user, topic));
        return exchange;
    }

    public IrcProducer createProducer() throws Exception {
        return new IrcProducer(this, this.component.getIRCConnection(this.configuration));
    }

    public IrcConsumer createConsumer(Processor processor) throws Exception {
        return new IrcConsumer(this, processor, this.component.getIRCConnection(this.configuration));
    }

    public IrcComponent getComponent() {
        return this.component;
    }

    public void setComponent(IrcComponent component) {
        this.component = component;
    }

    public IrcBinding getBinding() {
        if (this.binding == null) {
            this.binding = new IrcBinding();
        }
        return this.binding;
    }

    public void setBinding(IrcBinding binding) {
        this.binding = binding;
    }

    public IrcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IrcConfiguration configuration) {
        this.configuration = configuration;
    }

    public void handleIrcError(int num, String msg) {
        if (433 == num) {
            this.handleNickInUse();
        }
    }

    private void handleNickInUse() {
        IRCConnection connection = this.component.getIRCConnection(this.configuration);
        String nick = connection.getNick() + "-";
        if (nick.endsWith("----")) {
            LOG.error((Object)("Unable to set nick: " + nick + " disconnecting"));
        } else {
            LOG.warn((Object)("Unable to set nick: " + nick + " Retrying with " + nick + "-"));
            connection.doNick(nick);
            this.joinChannels();
        }
    }

    private DefaultExchange getExchange() {
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, this.getExchangePattern());
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        return exchange;
    }

    public void joinChannels() {
        for (String channel : this.configuration.getChannels()) {
            this.joinChannel(channel);
        }
    }

    public void joinChannel(String channel) {
        List<String> channels = this.configuration.getChannels();
        IRCConnection connection = this.component.getIRCConnection(this.configuration);
        String key = this.configuration.getKey(channel);
        if (ObjectHelper.isNotEmpty((Object)key)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Joining: " + channel + " using " + connection.getClass().getName() + " with key " + key));
            }
            connection.doJoin(channel, key);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Joining: " + channel + " using " + connection.getClass().getName()));
            }
            connection.doJoin(channel);
        }
    }
}

