/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.irc.IrcBinding;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.schwering.irc.lib.IRCUser;

public class IrcMessage
extends DefaultMessage {
    private String messageType;
    private String target;
    private IRCUser user;
    private String whoWasKickedNick;
    private String message;
    private int num;
    private String value;

    public IrcMessage(CamelContext camelContext) {
        super(camelContext);
    }

    public IrcMessage(CamelContext camelContext, String messageType, IRCUser user, String message) {
        super(camelContext);
        this.messageType = messageType;
        this.user = user;
        this.message = message;
        this.setBody(message);
    }

    public IrcMessage(CamelContext camelContext, String messageType, String target, IRCUser user, String message) {
        super(camelContext);
        this.messageType = messageType;
        this.target = target;
        this.user = user;
        this.message = message;
        this.setBody(message);
    }

    public IrcMessage(CamelContext camelContext, String messageType, String target, IRCUser user, String whoWasKickedNick, String message) {
        super(camelContext);
        this.messageType = messageType;
        this.target = target;
        this.user = user;
        this.whoWasKickedNick = whoWasKickedNick;
        this.message = message;
        this.setBody(message);
    }

    public IrcMessage(CamelContext camelContext, String messageType, String target, IRCUser user) {
        super(camelContext);
        this.messageType = messageType;
        this.target = target;
        this.user = user;
    }

    public IrcMessage(CamelContext camelContext, String messageType, int num, String value, String message) {
        super(camelContext);
        this.messageType = messageType;
        this.num = num;
        this.value = value;
        this.message = message;
        this.setBody(message);
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public IRCUser getUser() {
        return this.user;
    }

    public void setUser(IRCUser user) {
        this.user = user;
    }

    public String getWhoWasKickedNick() {
        return this.whoWasKickedNick;
    }

    public void setWhoWasKickedNick(String whoWasKickedNick) {
        this.whoWasKickedNick = whoWasKickedNick;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected Object createBody() {
        IrcBinding binding = (IrcBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), IrcBinding.class);
        return binding != null ? binding.extractBodyFromIrc(this) : null;
    }

    public IrcMessage newInstance() {
        return new IrcMessage(this.getCamelContext());
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        map.put("irc.messageType", this.messageType);
        if (this.target != null) {
            map.put("irc.target", this.target);
        }
        if (this.whoWasKickedNick != null) {
            map.put("irc.user.kicked", this.whoWasKickedNick);
        }
        if (this.user != null) {
            map.put("irc.user.host", this.user.getHost());
            map.put("irc.user.nick", this.user.getNick());
            map.put("irc.user.servername", this.user.getServername());
            map.put("irc.user.username", this.user.getUsername());
        }
        if (this.value != null) {
            map.put("irc.num", this.num);
            map.put("irc.value", this.value);
        }
    }

    public String toString() {
        if (this.message != null) {
            return "IrcMessage: " + this.message;
        }
        return "IrcMessage: " + String.valueOf(this.getBody());
    }
}

