/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ironmq;

import io.iron.ironmq.EmptyQueueException;
import io.iron.ironmq.Messages;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.ironmq.GsonUtil;
import org.apache.camel.component.ironmq.IronMQEndpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IronMQConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(IronMQConsumer.class);
    private io.iron.ironmq.Queue ironQueue;

    public IronMQConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.ironQueue = this.getEndpoint().getClient().queue(this.getEndpoint().getConfiguration().getQueueName());
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        try {
            LOG.trace("Receiving messages with request [messagePerPoll {}, timeout {}]...", (Object)this.getMaxMessagesPerPoll(), (Object)this.getEndpoint().getConfiguration().getTimeout());
            Messages messages = this.ironQueue.reserve(this.getMaxMessagesPerPoll(), this.getEndpoint().getConfiguration().getTimeout(), this.getEndpoint().getConfiguration().getWait());
            LOG.trace("Received {} messages", (Object)messages.getSize());
            Queue<Exchange> exchanges = this.createExchanges(messages.getMessages());
            int noProcessed = this.processBatch(CastUtils.cast(exchanges));
            if (this.getEndpoint().getConfiguration().isBatchDelete()) {
                LOG.trace("Batch deleting {} messages", (Object)messages.getSize());
                this.ironQueue.deleteMessages(messages);
            }
            return noProcessed;
        }
        catch (EmptyQueueException e) {
            return 0;
        }
    }

    protected Queue<Exchange> createExchanges(io.iron.ironmq.Message[] messages) {
        LOG.trace("Received {} messages in this poll", (Object)messages.length);
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        for (io.iron.ironmq.Message message : messages) {
            Exchange exchange = this.createExchange(message);
            answer.add(exchange);
        }
        return answer;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            final Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            if (!this.getEndpoint().getConfiguration().isBatchDelete()) {
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(new Synchronization(){
                    final String reservationId;
                    final String messageid;
                    {
                        this.reservationId = (String)ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"CamelIronMQReservationId", String.class);
                        this.messageid = (String)ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"CamelIronMQMessageId", String.class);
                    }

                    public void onComplete(Exchange exchange2) {
                        IronMQConsumer.this.processCommit(exchange2, this.messageid, this.reservationId);
                    }

                    public void onFailure(Exchange exchange2) {
                        IronMQConsumer.this.processRollback(exchange2);
                    }

                    public String toString() {
                        return "IronMQConsumerOnCompletion";
                    }
                });
            }
            LOG.trace("Processing exchange [{}]...", (Object)exchange);
            this.getProcessor().process(exchange);
        }
        return total;
    }

    protected void processCommit(Exchange exchange, String messageid, String reservationId) {
        try {
            LOG.trace("Deleting message with messageId {} and reservationId {}...", (Object)messageid, (Object)reservationId);
            this.ironQueue.deleteMessage(messageid, reservationId);
            LOG.trace("Message deleted");
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error occurred during delete of message. This exception is ignored.", exchange, (Throwable)e);
        }
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange, (Object)cause);
        } else {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange);
        }
    }

    public IronMQEndpoint getEndpoint() {
        return (IronMQEndpoint)super.getEndpoint();
    }

    private Exchange createExchange(io.iron.ironmq.Message msg) {
        Exchange exchange = this.createExchange(true);
        exchange.setPattern(this.getEndpoint().getExchangePattern());
        Message message = exchange.getIn();
        if (this.getEndpoint().getConfiguration().isPreserveHeaders()) {
            GsonUtil.copyFrom(msg, message);
        } else {
            message.setBody((Object)msg.getBody());
        }
        message.setHeader("CamelIronMQMessageId", (Object)msg.getId());
        message.setHeader("CamelIronMQReservationId", (Object)msg.getReservationId());
        message.setHeader("CamelIronMQReservedCount", (Object)msg.getReservedCount());
        return exchange;
    }
}

