/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jacksonxml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonXMLDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonXMLDataFormat.class);
    private CamelContext camelContext;
    private XmlMapper xmlMapper;
    private Class<? extends Collection> collectionType;
    private List<Module> modules;
    private String moduleClassNames;
    private String moduleRefs;
    private Class<?> unmarshalType;
    private Class<?> jsonView;
    private String include;
    private boolean prettyPrint;
    private boolean allowJmsType;
    private boolean useList;
    private boolean enableJaxbAnnotationModule;
    private String enableFeatures;
    private String disableFeatures;
    private boolean enableJacksonTypeConverter;
    private boolean allowUnmarshallType;
    private boolean contentTypeHeader = true;
    private TimeZone timezone;

    public JacksonXMLDataFormat() {
        this(HashMap.class);
    }

    public JacksonXMLDataFormat(Class<?> unmarshalType) {
        this(unmarshalType, null);
    }

    public JacksonXMLDataFormat(Class<?> unmarshalType, Class<?> jsonView) {
        this(unmarshalType, jsonView, true);
    }

    public JacksonXMLDataFormat(Class<?> unmarshalType, Class<?> jsonView, boolean enableJaxbAnnotationModule) {
        this.unmarshalType = unmarshalType;
        this.jsonView = jsonView;
        this.enableJaxbAnnotationModule = enableJaxbAnnotationModule;
    }

    public JacksonXMLDataFormat(XmlMapper mapper, Class<?> unmarshalType) {
        this(mapper, unmarshalType, null);
    }

    public JacksonXMLDataFormat(XmlMapper mapper, Class<?> unmarshalType, Class<?> jsonView) {
        this.xmlMapper = mapper;
        this.unmarshalType = unmarshalType;
        this.jsonView = jsonView;
    }

    public String getDataFormatName() {
        return "xml-jackson";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        this.xmlMapper.writerWithView(this.jsonView).writeValue(stream, graph);
        if (this.contentTypeHeader) {
            if (exchange.hasOut()) {
                exchange.getOut().setHeader("Content-Type", (Object)"application/xml");
            } else {
                exchange.getIn().setHeader("Content-Type", (Object)"application/xml");
            }
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        Class clazz = this.unmarshalType;
        String type = null;
        if (this.allowUnmarshallType) {
            type = (String)exchange.getIn().getHeader("CamelJacksonXmlUnmarshalType", String.class);
        }
        if (type == null && this.isAllowJmsType()) {
            type = (String)exchange.getIn().getHeader("JMSType", String.class);
        }
        if (type != null) {
            clazz = exchange.getContext().getClassResolver().resolveMandatoryClass(type);
        }
        if (this.collectionType != null) {
            CollectionType collType = this.xmlMapper.getTypeFactory().constructCollectionType(this.collectionType, clazz);
            return this.xmlMapper.readValue(stream, (JavaType)collType);
        }
        return this.xmlMapper.readValue(stream, clazz);
    }

    public XmlMapper getXmlMapper() {
        return this.xmlMapper;
    }

    public void setXmlMapper(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public Class<? extends Collection> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<? extends Collection> collectionType) {
        this.collectionType = collectionType;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public boolean isAllowJmsType() {
        return this.allowJmsType;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isUseList() {
        return this.useList;
    }

    public void setUseList(boolean useList) {
        this.useList = useList;
    }

    public boolean isEnableJaxbAnnotationModule() {
        return this.enableJaxbAnnotationModule;
    }

    public void setEnableJaxbAnnotationModule(boolean enableJaxbAnnotationModule) {
        this.enableJaxbAnnotationModule = enableJaxbAnnotationModule;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public String getModuleClassNames() {
        return this.moduleClassNames;
    }

    public void addModule(Module module) {
        if (this.modules == null) {
            this.modules = new ArrayList<Module>();
        }
        this.modules.add(module);
    }

    public void setModuleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
    }

    public String getModuleRefs() {
        return this.moduleRefs;
    }

    public void setModuleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
    }

    public void useList() {
        this.setCollectionType(ArrayList.class);
    }

    public void useMap() {
        this.setCollectionType(null);
        this.setUnmarshalType(HashMap.class);
    }

    public void setAllowJmsType(boolean allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public boolean isEnableJacksonTypeConverter() {
        return this.enableJacksonTypeConverter;
    }

    public void setEnableJacksonTypeConverter(boolean enableJacksonTypeConverter) {
        this.enableJacksonTypeConverter = enableJacksonTypeConverter;
    }

    public boolean isAllowUnmarshallType() {
        return this.allowUnmarshallType;
    }

    public void setAllowUnmarshallType(boolean allowJacksonUnmarshallType) {
        this.allowUnmarshallType = allowJacksonUnmarshallType;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    public void enableFeature(SerializationFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void enableFeature(DeserializationFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void enableFeature(MapperFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void disableFeature(SerializationFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    public void disableFeature(DeserializationFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    public void disableFeature(MapperFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    protected void doStart() throws Exception {
        String name;
        Object o;
        Iterator iterator;
        MapperFeature mf;
        DeserializationFeature df;
        SerializationFeature sf;
        Object it;
        if (this.xmlMapper == null) {
            this.xmlMapper = new XmlMapper();
        }
        if (this.enableJaxbAnnotationModule) {
            JaxbAnnotationModule module = new JaxbAnnotationModule();
            LOG.info("Registering module: {}", (Object)module);
            this.xmlMapper.registerModule((Module)module);
        }
        if (this.useList) {
            this.setCollectionType(ArrayList.class);
        }
        if (this.include != null) {
            JsonInclude.Include inc = (JsonInclude.Include)this.getCamelContext().getTypeConverter().mandatoryConvertTo(JsonInclude.Include.class, (Object)this.include);
            this.xmlMapper.setSerializationInclusion(inc);
        }
        if (this.prettyPrint) {
            this.xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        if (this.enableFeatures != null) {
            it = ObjectHelper.createIterator((Object)this.enableFeatures);
            while (it.hasNext()) {
                String enable = it.next().toString();
                sf = (SerializationFeature)this.getCamelContext().getTypeConverter().tryConvertTo(SerializationFeature.class, (Object)enable);
                if (sf != null) {
                    this.xmlMapper.enable(sf);
                    continue;
                }
                df = (DeserializationFeature)this.getCamelContext().getTypeConverter().tryConvertTo(DeserializationFeature.class, (Object)enable);
                if (df != null) {
                    this.xmlMapper.enable(df);
                    continue;
                }
                mf = (MapperFeature)this.getCamelContext().getTypeConverter().tryConvertTo(MapperFeature.class, (Object)enable);
                if (mf != null) {
                    this.xmlMapper.enable(new MapperFeature[]{mf});
                    continue;
                }
                throw new IllegalArgumentException("Enable feature: " + enable + " cannot be converted to an accepted enum of types [SerializationFeature,DeserializationFeature,MapperFeature]");
            }
        }
        if (this.disableFeatures != null) {
            it = ObjectHelper.createIterator((Object)this.disableFeatures);
            while (it.hasNext()) {
                String disable = it.next().toString();
                sf = (SerializationFeature)this.getCamelContext().getTypeConverter().tryConvertTo(SerializationFeature.class, (Object)disable);
                if (sf != null) {
                    this.xmlMapper.disable(sf);
                    continue;
                }
                df = (DeserializationFeature)this.getCamelContext().getTypeConverter().tryConvertTo(DeserializationFeature.class, (Object)disable);
                if (df != null) {
                    this.xmlMapper.disable(df);
                    continue;
                }
                mf = (MapperFeature)this.getCamelContext().getTypeConverter().tryConvertTo(MapperFeature.class, (Object)disable);
                if (mf != null) {
                    this.xmlMapper.disable(new MapperFeature[]{mf});
                    continue;
                }
                throw new IllegalArgumentException("Disable feature: " + disable + " cannot be converted to an accepted enum of types [SerializationFeature,DeserializationFeature,MapperFeature]");
            }
        }
        if (this.modules != null) {
            for (Module module : this.modules) {
                LOG.info("Registering module: {}", (Object)module);
                this.xmlMapper.registerModules(new Module[]{module});
            }
        }
        if (this.moduleClassNames != null) {
            it = ObjectHelper.createIterable((Object)this.moduleClassNames);
            iterator = it.iterator();
            while (iterator.hasNext()) {
                o = iterator.next();
                name = o.toString();
                Class clazz = this.camelContext.getClassResolver().resolveMandatoryClass(name, Module.class);
                Module module = (Module)this.camelContext.getInjector().newInstance(clazz);
                LOG.info("Registering module: {} -> {}", (Object)name, (Object)module);
                this.xmlMapper.registerModule(module);
            }
        }
        if (this.moduleRefs != null) {
            it = ObjectHelper.createIterable((Object)this.moduleRefs);
            iterator = it.iterator();
            while (iterator.hasNext()) {
                o = iterator.next();
                name = o.toString();
                if (name.startsWith("#")) {
                    name = name.substring(1);
                }
                Module module = (Module)CamelContextHelper.mandatoryLookup((CamelContext)this.camelContext, (String)name, Module.class);
                LOG.info("Registering module: {} -> {}", (Object)name, (Object)module);
                this.xmlMapper.registerModule(module);
            }
        }
        if (ObjectHelper.isNotEmpty((Object)this.timezone)) {
            LOG.debug("Setting timezone to XML Mapper: {}", (Object)this.timezone);
            this.xmlMapper.setTimeZone(this.timezone);
        }
    }

    protected void doStop() throws Exception {
    }
}

