/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.javaspace;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.server.UID;
import net.jini.core.entry.Entry;
import net.jini.core.transaction.Transaction;
import net.jini.space.JavaSpace;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.javaspace.InEntry;
import org.apache.camel.component.javaspace.JavaSpaceEndpoint;
import org.apache.camel.component.javaspace.JiniSpaceAccessor;
import org.apache.camel.component.javaspace.OutEntry;
import org.apache.camel.component.javaspace.TransactionHelper;
import org.apache.camel.component.javaspace.Utility;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSpaceProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSpaceProducer.class);
    private final boolean transactional;
    private final long transactionTimeout;
    private JavaSpace javaSpace;
    private TransactionHelper transactionHelper;

    public JavaSpaceProducer(JavaSpaceEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.transactional = endpoint.isTransactional();
        this.transactionTimeout = endpoint.getTransactionTimeout();
    }

    public void process(Exchange exchange) throws Exception {
        Entry entry;
        Object body = exchange.getIn().getBody();
        if (!(body instanceof Entry)) {
            entry = new InEntry();
            if (body instanceof BeanInvocation) {
                ((InEntry)entry).correlationId = new UID().toString();
            }
            if (body instanceof byte[]) {
                ((InEntry)entry).binary = true;
                ((InEntry)entry).buffer = (byte[])body;
            } else {
                ((InEntry)entry).binary = false;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(body);
                ((InEntry)entry).buffer = bos.toByteArray();
            }
        } else {
            entry = (Entry)body;
        }
        Transaction tnx = null;
        if (this.transactionHelper != null) {
            tnx = this.transactionHelper.getJiniTransaction((long)this.transactionTimeout).transaction;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing body : {}", (Object)entry);
        }
        this.javaSpace.write(entry, tnx, Long.MAX_VALUE);
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            Object obj;
            OutEntry tmpl = new OutEntry();
            tmpl.correlationId = ((InEntry)entry).correlationId;
            OutEntry replyCamelEntry = null;
            while (replyCamelEntry == null) {
                replyCamelEntry = (OutEntry)this.javaSpace.take((Entry)tmpl, tnx, 100L);
            }
            if (replyCamelEntry.binary.booleanValue()) {
                obj = replyCamelEntry.buffer;
            } else {
                ByteArrayInputStream bis = new ByteArrayInputStream(replyCamelEntry.buffer);
                ObjectInputStream ois = new ObjectInputStream(bis);
                obj = ois.readObject();
            }
            exchange.getOut().setBody(obj);
        }
        if (tnx != null) {
            tnx.commit();
        }
    }

    protected void doStart() throws Exception {
        Utility.setSecurityPolicy("policy.all", "policy_producer.all");
        this.javaSpace = JiniSpaceAccessor.findSpace(((JavaSpaceEndpoint)this.getEndpoint()).getUrl(), ((JavaSpaceEndpoint)this.getEndpoint()).getSpaceName());
        if (this.transactional) {
            this.transactionHelper = TransactionHelper.getInstance(((JavaSpaceEndpoint)this.getEndpoint()).getUrl());
        }
        new File("policy_producer.all").delete();
    }

    protected void doStop() throws Exception {
    }
}

