/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import java.util.Arrays;

public enum ClusterType {
    KUBERNETES,
    OPENSHIFT,
    KIND,
    MINIKUBE;


    public static ClusterType fromName(String name) {
        return Arrays.stream(ClusterType.values()).filter(ct -> ct.name().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown cluster type: %s".formatted(name)));
    }

    public boolean isEqualTo(String clusterType) {
        if (clusterType == null) {
            return false;
        }
        return this == ClusterType.fromName(clusterType);
    }
}

