/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.dsl.jbang.core.common.SourceScheme;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Delete Camel application from Kubernetes"}, sortOptions=false)
public class KubernetesDelete
extends KubernetesBaseCommand {
    @CommandLine.Parameters(description={"The Camel file to delete. Integration name is derived from the file name."}, arity="0..1", paramLabel="<file>")
    String filePath;
    @CommandLine.Option(names={"--name"}, description={"The integration name. Use this when the name should not get derived from the source file name."})
    String name;
    @CommandLine.Option(names={"--working-dir"}, description={"The working directory where to find exported project sources."})
    String workingDir;

    public KubernetesDelete(CamelJBangMain main) {
        super(main);
    }

    public Integer doCall() throws Exception {
        File resolvedWorkingDir;
        if (this.workingDir != null) {
            resolvedWorkingDir = new File(this.workingDir);
        } else {
            String projectName;
            if (this.name != null) {
                projectName = KubernetesHelper.sanitize(this.name);
            } else if (this.filePath != null) {
                projectName = KubernetesHelper.sanitize(FileUtil.onlyName((String)SourceScheme.onlyName((String)this.filePath)));
            } else {
                this.printer().println("Name or source file must be set");
                return 1;
            }
            resolvedWorkingDir = new File(".camel-jbang-run/" + projectName);
        }
        if (!resolvedWorkingDir.exists()) {
            this.printer().printf("Failed to resolve exported project from path '%s'%n", new Object[]{resolvedWorkingDir});
            return 1;
        }
        File manifest = KubernetesHelper.resolveKubernetesManifest(new File(resolvedWorkingDir, "target/kubernetes"));
        try (FileInputStream fis = new FileInputStream(manifest);){
            List status = this.namespace != null ? ((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.client().load((InputStream)fis).inNamespace(this.namespace)).delete() : this.client().load((InputStream)fis).delete();
            status.forEach(s -> this.printer().printf("Deleted: %s '%s'%n", new Object[]{StringHelper.capitalize((String)s.getKind()), s.getName()}));
        }
        return 0;
    }
}

