/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecFluent;
import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.BaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.v1.integrationspec.Traits;

public class ContainerTrait
extends BaseTrait {
    public static final int CONTAINER_TRAIT_ORDER = 1600;
    public static final int DEFAULT_CONTAINER_PORT = 8080;
    public static final String DEFAULT_CONTAINER_PORT_NAME = "http";

    public ContainerTrait() {
        super("container", 1600);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        return traitConfig.getContainer() == null || Optional.ofNullable(traitConfig.getContainer().getEnabled()).orElse(true) != false;
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        org.apache.camel.v1.integrationspec.traits.Container containerTrait = Optional.ofNullable(traitConfig.getContainer()).orElseGet(org.apache.camel.v1.integrationspec.traits.Container::new);
        ContainerBuilder container = (ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(Optional.ofNullable(containerTrait.getName()).orElse(context.getName()))).withImage(containerTrait.getImage());
        if (containerTrait.getImagePullPolicy() != null) {
            container.withImagePullPolicy(containerTrait.getImagePullPolicy().getValue());
        }
        if (containerTrait.getPort() != null || context.getService().isPresent() || context.getKnativeService().isPresent()) {
            container.addToPorts(new ContainerPort[]{((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName(Optional.ofNullable(containerTrait.getPortName()).orElse(DEFAULT_CONTAINER_PORT_NAME))).withContainerPort(Optional.ofNullable(containerTrait.getPort()).map(Long::intValue).orElse(8080))).withProtocol("TCP")).build()});
        }
        ResourceRequirementsBuilder resourceRequirementsBuilder = new ResourceRequirementsBuilder();
        if (containerTrait.getRequestMemory() != null) {
            resourceRequirementsBuilder.addToRequests("memory", new Quantity(containerTrait.getRequestMemory()));
        }
        if (containerTrait.getRequestCPU() != null) {
            resourceRequirementsBuilder.addToRequests("cpu", new Quantity(containerTrait.getRequestCPU()));
        }
        if (containerTrait.getLimitMemory() != null) {
            resourceRequirementsBuilder.addToLimits("memory", new Quantity(containerTrait.getLimitMemory()));
        }
        if (containerTrait.getLimitCPU() != null) {
            resourceRequirementsBuilder.addToLimits("cpu", new Quantity(containerTrait.getLimitCPU()));
        }
        container.withResources(resourceRequirementsBuilder.build());
        context.doWithDeployments((Visitor<DeploymentBuilder>)((Visitor)d -> ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)d.editOrNewSpec().editOrNewTemplate().editOrNewMetadata().addToLabels("camel.apache.org/integration", context.getName())).endMetadata()).editOrNewSpec().addToContainers(new Container[]{container.build()})).endSpec()).endTemplate()).endSpec()));
        context.doWithCronJobs((Visitor<CronJobBuilder>)((Visitor)j -> ((CronJobFluent.SpecNested)((CronJobSpecFluent.JobTemplateNested)((JobTemplateSpecFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((CronJobSpecFluent.JobTemplateNested)((JobTemplateSpecFluent.MetadataNested)j.editOrNewSpec().editOrNewJobTemplate().editOrNewMetadata().addToLabels("camel.apache.org/integration", context.getName())).endMetadata()).editOrNewSpec().editOrNewTemplate().editOrNewSpec().addToContainers(new Container[]{container.build()})).endSpec()).endTemplate()).endSpec()).endJobTemplate()).endSpec()));
    }
}

