/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRule;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent;
import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.BaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitProfile;
import org.apache.camel.v1.integrationspec.Traits;
import org.apache.camel.v1.integrationspec.traits.Container;
import org.apache.camel.v1.integrationspec.traits.Ingress;

public class IngressTrait
extends BaseTrait {
    public static final int IngressTrait = 2400;
    public static final String INGRESS_CLASS_NAME = "nginx";
    public static final String DEFAULT_INGRESS_HOST = "";
    public static final String DEFAULT_INGRESS_PATH = "/";
    public static final Ingress.PathType DEFAULT_INGRESS_PATH_TYPE = Ingress.PathType.PREFIX;

    public IngressTrait() {
        super("ingress", 2400);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        if (context.getIngress().isPresent()) {
            return false;
        }
        if (traitConfig.getIngress() == null || !Optional.ofNullable(traitConfig.getIngress().getEnabled()).orElse(false).booleanValue()) {
            return false;
        }
        return context.getService().isPresent();
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        Ingress ingressTrait = Optional.ofNullable(traitConfig.getIngress()).orElseGet(Ingress::new);
        Container containerTrait = Optional.ofNullable(traitConfig.getContainer()).orElseGet(Container::new);
        IngressBuilder ingressBuilder = new IngressBuilder();
        ((IngressFluent.MetadataNested)ingressBuilder.withNewMetadata().withName(context.getName())).endMetadata();
        if (ingressTrait.getAnnotations() != null) {
            ((IngressFluent.MetadataNested)ingressBuilder.editMetadata().withAnnotations(ingressTrait.getAnnotations())).endMetadata();
        }
        HTTPIngressPath path = ((HTTPIngressPathBuilder)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)((HTTPIngressPathBuilder)((HTTPIngressPathBuilder)new HTTPIngressPathBuilder().withPath(Optional.ofNullable(ingressTrait.getPath()).orElse(DEFAULT_INGRESS_PATH))).withPathType(Optional.ofNullable(ingressTrait.getPathType()).orElse(DEFAULT_INGRESS_PATH_TYPE).getValue())).withNewBackend().withNewService().withName(context.getName())).withNewPort().withName(Optional.ofNullable(containerTrait.getServicePortName()).orElse("http"))).endPort()).endService()).endBackend()).build();
        IngressRule rule = ((IngressRuleBuilder)((IngressRuleFluent.HttpNested)((IngressRuleBuilder)new IngressRuleBuilder().withHost(Optional.ofNullable(ingressTrait.getHost()).orElse(DEFAULT_INGRESS_HOST))).withNewHttp().withPaths(new HTTPIngressPath[]{path})).endHttp()).build();
        ((IngressFluent.SpecNested)((IngressFluent.SpecNested)ingressBuilder.withNewSpec().withIngressClassName(INGRESS_CLASS_NAME)).withRules(new IngressRule[]{rule})).endSpec();
        context.add((VisitableBuilder<?, ?>)ingressBuilder);
    }

    @Override
    public boolean accept(TraitProfile profile) {
        return TraitProfile.KUBERNETES == profile;
    }
}

