/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm.workitem;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.services.api.service.ServiceRegistry;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCamelWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler
implements Cacheable {
    private static Logger logger = LoggerFactory.getLogger(AbstractCamelWorkItemHandler.class);
    private ProducerTemplate producerTemplate;
    private final String camelEndpointId;
    private final String camelContextKey;
    private boolean initialized;

    public AbstractCamelWorkItemHandler() {
        this("");
    }

    public AbstractCamelWorkItemHandler(String camelEndointId) {
        this.camelEndpointId = camelEndointId;
        this.camelContextKey = "GlobalCamelService";
        this.producerTemplate = this.buildProducerTemplate(this.camelContextKey);
        this.initialized = true;
    }

    public AbstractCamelWorkItemHandler(RuntimeManager runtimeManager) {
        this(runtimeManager, "");
    }

    public AbstractCamelWorkItemHandler(RuntimeManager runtimeManager, String camelEndpointId) {
        this.camelEndpointId = camelEndpointId;
        this.camelContextKey = runtimeManager.getIdentifier() + "_CamelService";
        try {
            this.producerTemplate = this.buildProducerTemplate(this.camelContextKey);
            this.initialized = true;
        }
        catch (IllegalArgumentException iae) {
            String message = "CamelContext with identifier '" + this.camelContextKey + "' not found in ServiceRegistry. This can be caused by the order in which the platform extensions are initialized. Deferring Camel ProducerTemplate creation until the first WorkItemHandler call.";
            logger.info(message, (Throwable)iae);
        }
    }

    private ProducerTemplate buildProducerTemplate(String key) {
        CamelContext camelContext = (CamelContext)ServiceRegistry.get().service(key);
        this.producerTemplate = camelContext.createProducerTemplate();
        return this.producerTemplate;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        if (!this.initialized) {
            this.producerTemplate = this.buildProducerTemplate(this.camelContextKey);
            this.initialized = true;
        }
        String workItemCamelEndpointId = this.getCamelEndpointId(workItem);
        String camelUri = "direct:" + workItemCamelEndpointId;
        try {
            Exchange requestExchange = this.buildExchange(this.producerTemplate, workItem);
            logger.debug("Sending Camel Exchange to: " + camelUri);
            Exchange responseExchange = this.producerTemplate.send(camelUri, requestExchange);
            if (responseExchange.getException() != null) {
                throw responseExchange.getException();
            }
            this.handleResponse(responseExchange, workItem, manager);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected String getCamelEndpointId(WorkItem workItem) {
        String workItemCamelEndpointId = (String)workItem.getParameter("CamelEndpointId");
        if (this.camelEndpointId != null && !this.camelEndpointId.isEmpty()) {
            if (workItemCamelEndpointId != null && !workItemCamelEndpointId.isEmpty()) {
                logger.debug("The Camel Endpoint ID has been set on both the WorkItemHanlder and WorkItem. The 'CamelEndpointId' configured on the WorkItem overrides the global configuation.");
            } else {
                workItemCamelEndpointId = this.camelEndpointId;
            }
        }
        if (workItemCamelEndpointId == null || workItemCamelEndpointId.isEmpty()) {
            throw new IllegalArgumentException("No Camel Endpoint ID specified. Please configure the 'CamelEndpointId' in either the constructor of this WorkItemHandler, or pass it via the CamelEndpointId' WorkItem parameter.");
        }
        return workItemCamelEndpointId;
    }

    protected abstract void handleResponse(Exchange var1, WorkItem var2, WorkItemManager var3);

    protected abstract Exchange buildExchange(ProducerTemplate var1, WorkItem var2);

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public void close() {
        try {
            this.producerTemplate.stop();
        }
        catch (Exception e) {
            logger.warn("Error encountered while closing the Camel Producer Template.", (Throwable)e);
        }
    }
}

