/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm.listeners;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.jbpm.JBPMCamelConsumerAware;
import org.apache.camel.component.jbpm.JBPMConsumer;
import org.jbpm.casemgmt.api.event.CaseCancelEvent;
import org.jbpm.casemgmt.api.event.CaseCloseEvent;
import org.jbpm.casemgmt.api.event.CaseCommentEvent;
import org.jbpm.casemgmt.api.event.CaseDataEvent;
import org.jbpm.casemgmt.api.event.CaseDestroyEvent;
import org.jbpm.casemgmt.api.event.CaseDynamicSubprocessEvent;
import org.jbpm.casemgmt.api.event.CaseDynamicTaskEvent;
import org.jbpm.casemgmt.api.event.CaseEventListener;
import org.jbpm.casemgmt.api.event.CaseReopenEvent;
import org.jbpm.casemgmt.api.event.CaseRoleAssignmentEvent;
import org.jbpm.casemgmt.api.event.CaseStartEvent;
import org.kie.internal.runtime.Cacheable;

public class CamelCaseEventListener
implements CaseEventListener,
Cacheable,
JBPMCamelConsumerAware {
    private Set<JBPMConsumer> consumers = new LinkedHashSet<JBPMConsumer>();

    public void beforeCaseStarted(CaseStartEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseStarted", event);
    }

    public void afterCaseStarted(CaseStartEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseStarted", event);
    }

    public void beforeCaseClosed(CaseCloseEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseClosed", event);
    }

    public void afterCaseClosed(CaseCloseEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseClosed", event);
    }

    public void beforeCaseCancelled(CaseCancelEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseCancelled", event);
    }

    public void afterCaseCancelled(CaseCancelEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseCancelled", event);
    }

    public void beforeCaseDestroyed(CaseDestroyEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseDestroyed", event);
    }

    public void afterCaseDestroyed(CaseDestroyEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseDestroyed", event);
    }

    public void beforeCaseReopen(CaseReopenEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseReopen", event);
    }

    public void afterCaseReopen(CaseReopenEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseReopen", event);
    }

    public void beforeCaseCommentAdded(CaseCommentEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseCommentAdded", event);
    }

    public void afterCaseCommentAdded(CaseCommentEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseCommentAdded", event);
    }

    public void beforeCaseCommentUpdated(CaseCommentEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseCommentUpdated", event);
    }

    public void afterCaseCommentUpdated(CaseCommentEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseCommentUpdated", event);
    }

    public void beforeCaseCommentRemoved(CaseCommentEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseCommentRemoved", event);
    }

    public void afterCaseCommentRemoved(CaseCommentEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseCommentRemoved", event);
    }

    public void beforeCaseRoleAssignmentAdded(CaseRoleAssignmentEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseRoleAssignmentAdded", event);
    }

    public void afterCaseRoleAssignmentAdded(CaseRoleAssignmentEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseRoleAssignmentAdded", event);
    }

    public void beforeCaseRoleAssignmentRemoved(CaseRoleAssignmentEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseRoleAssignmentRemoved", event);
    }

    public void afterCaseRoleAssignmentRemoved(CaseRoleAssignmentEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseRoleAssignmentRemoved", event);
    }

    public void beforeCaseDataAdded(CaseDataEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseDataAdded", event);
    }

    public void afterCaseDataAdded(CaseDataEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseDataAdded", event);
    }

    public void beforeCaseDataRemoved(CaseDataEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeCaseDataRemoved", event);
    }

    public void afterCaseDataRemoved(CaseDataEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterCaseDataRemoved", event);
    }

    public void beforeDynamicTaskAdded(CaseDynamicTaskEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeDynamicTaskAdded", event);
    }

    public void afterDynamicTaskAdded(CaseDynamicTaskEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterDynamicTaskAdded", event);
    }

    public void beforeDynamicProcessAdded(CaseDynamicSubprocessEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("beforeDynamicProcessAdded", event);
    }

    public void afterDynamicProcessAdded(CaseDynamicSubprocessEvent event) {
        if (this.consumers.isEmpty()) {
            return;
        }
        this.sendMessage("afterDynamicProcessAdded", event);
    }

    public void close() {
    }

    @Override
    public void addConsumer(JBPMConsumer consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void removeConsumer(JBPMConsumer consumer) {
        this.consumers.remove((Object)consumer);
    }

    protected void sendMessage(String eventType, Object event) {
        this.consumers.stream().filter(c -> c.getStatus().isStarted()).forEach(c -> c.sendMessage(eventType, event));
    }
}

