/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm.server;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.jbpm.config.CamelContextBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.util.ObjectHelper;
import org.jbpm.services.api.service.ServiceRegistry;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelKieServerExtension
implements KieServerExtension {
    public static final String EXTENSION_NAME = "Camel";
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelKieServerExtension.class);
    private static final Boolean DISABLED = Boolean.parseBoolean(System.getProperty("org.camel.server.ext.disabled", "false"));
    protected DefaultCamelContext camelContext;
    protected boolean managedCamel;
    protected Map<String, DefaultCamelContext> camelContexts = new HashMap<String, DefaultCamelContext>();
    protected CamelContextBuilder camelContextBuilder;

    public CamelKieServerExtension() {
        this.managedCamel = true;
        this.camelContextBuilder = this.discoverCamelContextBuilder();
    }

    public CamelKieServerExtension(CamelContextBuilder camelContextBuilder) {
        this.managedCamel = true;
        this.camelContextBuilder = camelContextBuilder;
    }

    public CamelKieServerExtension(DefaultCamelContext camelContext) {
        this.camelContext = camelContext;
        this.managedCamel = false;
        this.camelContextBuilder = this.discoverCamelContextBuilder();
    }

    public CamelKieServerExtension(DefaultCamelContext camelContext, CamelContextBuilder camelContextBuilder) {
        this.camelContext = camelContext;
        this.managedCamel = false;
        this.camelContextBuilder = camelContextBuilder;
    }

    public boolean isInitialized() {
        return this.camelContext != null;
    }

    public boolean isActive() {
        return DISABLED == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        if (this.managedCamel && this.camelContext == null) {
            this.camelContext = (DefaultCamelContext)this.buildGlobalContext();
            this.camelContext.setName("KIE Server Camel context");
            try (InputStream is = ObjectHelper.loadResourceAsStream((String)"/global-camel-routes.xml", (ClassLoader)this.getClass().getClassLoader());){
                if (is != null) {
                    ExtendedCamelContext ecc = (ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class);
                    RoutesDefinition routes = (RoutesDefinition)ecc.getXMLRoutesDefinitionLoader().loadRoutesDefinition((CamelContext)this.camelContext, is);
                    this.camelContext.addRouteDefinitions((Collection)routes.getRoutes());
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while adding Camel context for KIE Server", (Throwable)e);
            }
        }
        ServiceRegistry.get().register("GlobalCamelService", (Object)this.camelContext);
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
        ServiceRegistry.get().remove("GlobalCamelService");
        if (this.managedCamel && this.camelContext != null) {
            try {
                this.camelContext.stop();
            }
            catch (Exception e) {
                LOGGER.error("Failed at stopping KIE Server extension {}", (Object)EXTENSION_NAME);
            }
        }
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        ClassLoader classloader = kieContainerInstance.getKieContainer().getClassLoader();
        try (InputStream is = ObjectHelper.loadResourceAsStream((String)"camel-routes.xml", (ClassLoader)this.getClass().getClassLoader());){
            if (is != null) {
                DefaultCamelContext context = (DefaultCamelContext)this.buildDeploymentContext(id, classloader);
                context.setName("KIE Server Camel context for container " + kieContainerInstance.getContainerId());
                ExtendedCamelContext ecc = (ExtendedCamelContext)context.adapt(ExtendedCamelContext.class);
                RoutesDefinition routes = (RoutesDefinition)ecc.getXMLRoutesDefinitionLoader().loadRoutesDefinition((CamelContext)context, is);
                this.annotateKJarRoutes(routes, id);
                context.addRouteDefinitions((Collection)routes.getRoutes());
                context.start();
                this.camelContexts.put(id, context);
                ServiceRegistry.get().register(id + "_CamelService", (Object)context);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while adding Camel context for {}", (Object)kieContainerInstance.getContainerId(), (Object)e);
        }
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        this.disposeContainer(id, kieContainerInstance, parameters);
        this.createContainer(id, kieContainerInstance, parameters);
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        DefaultCamelContext context = this.camelContexts.get(id);
        if (context != null) {
            ServiceRegistry.get().remove(id + "_CamelService");
            try {
                context.stop();
            }
            catch (Exception e) {
                LOGGER.error("Error while removing Camel context for container {}", (Object)id, (Object)e);
            }
        }
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        return Collections.emptyList();
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        return null;
    }

    public String getImplementedCapability() {
        return "Integration";
    }

    public List<Object> getServices() {
        return Collections.emptyList();
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 50;
    }

    public void serverStarted() {
        if (this.managedCamel && this.camelContext != null && !this.camelContext.isStarted()) {
            try {
                this.camelContext.start();
            }
            catch (Exception e) {
                LOGGER.error("Failed at start Camel context", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "Camel KIE Server extension";
    }

    public DefaultCamelContext getCamelContext() {
        return this.camelContext;
    }

    public CamelContextBuilder getCamelContextBuilder() {
        return this.camelContextBuilder;
    }

    protected void annotateKJarRoutes(RoutesDefinition routes, String deploymentId) {
        for (RouteDefinition route : routes.getRoutes()) {
            FromDefinition from = route.getInput();
            if (!from.getUri().startsWith("jbpm:events") || from.getUri().contains("deploymentId")) continue;
            StringBuilder uri = new StringBuilder(from.getUri());
            String[] split = from.getUri().split("\\?");
            if (split.length == 1) {
                uri.append("?");
            } else {
                uri.append("&");
            }
            uri.append("deploymentId=").append(deploymentId);
            from.setUri(uri.toString());
        }
    }

    protected CamelContext buildGlobalContext() {
        if (this.camelContextBuilder != null) {
            return this.camelContextBuilder.buildCamelContext();
        }
        return new CamelContextBuilder(){}.buildCamelContext();
    }

    protected CamelContext buildDeploymentContext(String identifier, ClassLoader classloader) {
        CamelContextBuilder deploymentContextBuilder;
        InternalRuntimeManager runtimeManager = (InternalRuntimeManager)RuntimeManagerRegistry.get().getManager(identifier);
        if (runtimeManager != null && (deploymentContextBuilder = (CamelContextBuilder)runtimeManager.getEnvironment().getEnvironment().get("CamelContextBuilder")) != null) {
            return deploymentContextBuilder.buildCamelContext();
        }
        CamelContext camelContext = new CamelContextBuilder(){}.buildCamelContext();
        camelContext.setApplicationContextClassLoader(classloader);
        return camelContext;
    }

    protected CamelContextBuilder discoverCamelContextBuilder() {
        ServiceLoader<CamelContextBuilder> builders = ServiceLoader.load(CamelContextBuilder.class);
        Iterator<CamelContextBuilder> it = builders.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }
}

