/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import org.apache.camel.component.jcache.JCacheProvider;

public enum JCacheProviders implements JCacheProvider
{
    hazelcast{
        {
            this.shortName = "hazelcast";
            this.className = "com.hazelcast.cache.HazelcastCachingProvider";
        }
    }
    ,
    ehcache{
        {
            this.shortName = "ehcache";
            this.className = "org.ehcache.jsr107.EhcacheCachingProvider";
        }
    }
    ,
    caffeine{
        {
            this.shortName = "caffeine";
            this.className = "com.github.benmanes.caffeine.jcache.spi.CaffeineCachingProvider";
        }
    }
    ,
    ispnEmbedded{
        {
            this.shortName = "infinispan-embedded";
            this.className = "org.infinispan.jcache.embedded.JCachingProvider";
        }
    };

    protected String shortName;
    protected String className;

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String className() {
        return this.className;
    }

    public static JCacheProvider lookup(final String providerName) {
        if (providerName != null) {
            for (JCacheProviders provider : JCacheProviders.values()) {
                if (!provider.shortName().equals(providerName) && !provider.className().equals(providerName)) continue;
                return provider;
            }
        }
        return new JCacheProvider(){

            @Override
            public String shortName() {
                return providerName;
            }

            @Override
            public String className() {
                return providerName;
            }
        };
    }
}

