/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache.policy;

import javax.cache.Cache;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCachePolicyProcessor
extends DelegateAsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JCachePolicyProcessor.class);
    private final CamelContext camelContext;
    private Cache cache;
    private Expression keyExpression;
    private Expression bypassExpression;

    public JCachePolicyProcessor(CamelContext camelContext, Cache cache, Expression keyExpression, Expression bypassExpression, Processor processor) {
        super(processor);
        this.camelContext = camelContext;
        this.cache = cache;
        this.keyExpression = keyExpression;
        this.bypassExpression = bypassExpression;
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        LOG.debug("JCachePolicy process started - cache:{}, exchange:{}", (Object)this.cache.getName(), (Object)exchange.getExchangeId());
        if (this.cache.isClosed()) {
            return super.process(exchange, callback);
        }
        try {
            Boolean bypass;
            Object key;
            Object object = key = this.keyExpression != null ? this.keyExpression.evaluate(exchange, Object.class) : exchange.getMessage().getBody();
            if (key == null) {
                return super.process(exchange, callback);
            }
            Boolean bl = bypass = this.bypassExpression != null ? (Boolean)this.bypassExpression.evaluate(exchange, Boolean.class) : Boolean.FALSE;
            if (!Boolean.TRUE.equals(bypass)) {
                Object value = this.cache.get(key);
                if (value != null) {
                    LOG.debug("Cached object is found, skipping the route - key:{}, exchange:{}", key, (Object)exchange.getExchangeId());
                    exchange.getMessage().setBody(value);
                    callback.done(true);
                    return true;
                }
                LOG.debug("No cached object is found, continue route - key:{}, exchange:{}", key, (Object)exchange.getExchangeId());
            } else {
                LOG.debug("Bypassing cache - key:{}, exchange:{}", key, (Object)exchange.getExchangeId());
            }
            return super.process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    try {
                        Object value;
                        if (!exchange.isFailed() && (value = exchange.getMessage().getBody()) != null) {
                            LOG.debug("Saving in cache - key:{}, value:{}, exchange:{}", new Object[]{key, value, exchange.getExchangeId()});
                            JCachePolicyProcessor.this.cache.put(key, value);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error("Error storing in cache. - key:{}, exchange:{}", new Object[]{key, exchange.getExchangeId(), ex});
                    }
                    finally {
                        callback.done(doneSync);
                    }
                }
            });
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.keyExpression != null) {
            this.keyExpression.init(this.camelContext);
        }
    }

    protected void doStop() throws Exception {
        if (!this.cache.isClosed()) {
            this.cache.clear();
        }
        super.doStop();
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Expression getKeyExpression() {
        return this.keyExpression;
    }

    public void setKeyExpression(Expression keyExpression) {
        this.keyExpression = keyExpression;
    }

    public Expression getBypassExpression() {
        return this.bypassExpression;
    }

    public void setBypassExpression(Expression bypassExpression) {
        this.bypassExpression = bypassExpression;
    }
}

