/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.jcr.JcrEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.jackrabbit.util.Text;

public class JcrProducer
extends DefaultProducer {
    public JcrProducer(JcrEndpoint jcrEndpoint) throws RepositoryException {
        super((Endpoint)jcrEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        block9: {
            TypeConverter converter = exchange.getContext().getTypeConverter();
            Session session = this.openSession();
            Message message = exchange.getIn();
            String operation = this.determineOperation(message);
            try {
                if ("CamelJcrInsert".equals(operation)) {
                    Node base = this.findOrCreateNode(session.getRootNode(), this.getJcrEndpoint().getBase(), "");
                    Node node = this.findOrCreateNode(base, this.getNodeName(message), this.getNodeType(message));
                    Map<String, Object> headers = this.filterComponentHeaders(message.getHeaders());
                    for (String key : headers.keySet()) {
                        Value[] value;
                        Object header = message.getHeader(key);
                        if (header != null && Object[].class.isAssignableFrom(header.getClass())) {
                            value = (Value[])converter.convertTo(Value[].class, exchange, header);
                            node.setProperty(key, value);
                            continue;
                        }
                        value = (Value[])converter.convertTo(Value.class, exchange, header);
                        node.setProperty(key, (Value)value);
                    }
                    node.addMixin("mix:referenceable");
                    exchange.getOut().setBody((Object)node.getIdentifier());
                    session.save();
                    break block9;
                }
                if ("CamelJcrGetById".equals(operation)) {
                    Node node = session.getNodeByIdentifier((String)exchange.getIn().getMandatoryBody(String.class));
                    PropertyIterator properties = node.getProperties();
                    while (properties.hasNext()) {
                        Property property = properties.nextProperty();
                        Class<?> aClass = this.classForJCRType(property);
                        Object value = property.isMultiple() ? converter.convertTo(aClass, exchange, (Object)property.getValues()) : converter.convertTo(aClass, exchange, (Object)property.getValue());
                        message.setHeader(property.getName(), value);
                    }
                    break block9;
                }
                throw new RuntimeException("Unsupported operation: " + operation);
            }
            finally {
                if (session != null && session.isLive()) {
                    session.logout();
                }
            }
        }
    }

    private Map<String, Object> filterComponentHeaders(Map<String, Object> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>(properties.size());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (key.equals("CamelJcrNodeName") || key.equals("CamelJcrOperation") || key.equals("CamelJcrNodeType")) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Class<?> classForJCRType(Property property) throws RepositoryException {
        switch (property.getType()) {
            case 1: {
                return String.class;
            }
            case 2: {
                return InputStream.class;
            }
            case 6: {
                return Boolean.class;
            }
            case 3: {
                return Long.class;
            }
            case 4: {
                return Double.class;
            }
            case 12: {
                return BigDecimal.class;
            }
            case 5: {
                return Calendar.class;
            }
            case 7: {
                return String.class;
            }
            case 8: {
                return String.class;
            }
            case 9: {
                return String.class;
            }
            case 10: {
                return String.class;
            }
            case 11: {
                return String.class;
            }
            case 0: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("unknown type: " + property.getType());
    }

    private String determineOperation(Message message) {
        String operation = (String)message.getHeader("CamelJcrOperation", String.class);
        return operation != null ? operation : "CamelJcrInsert";
    }

    private String getNodeName(Message message) {
        String nodeName = (String)message.getHeader("CamelJcrNodeName", String.class);
        return nodeName != null ? nodeName : message.getExchange().getExchangeId();
    }

    private String getNodeType(Message message) {
        String nodeType = (String)message.getHeader("CamelJcrNodeType", String.class);
        return nodeType != null ? nodeType : "";
    }

    private Node findOrCreateNode(Node parent, String path, String nodeType) throws RepositoryException {
        Node result = parent;
        for (String component : path.split("/")) {
            if ((component = Text.escapeIllegalJcrChars((String)component)).length() <= 0) continue;
            result = result.hasNode(component) ? result.getNode(component) : (ObjectHelper.isNotEmpty((Object)nodeType) ? result.addNode(component, nodeType) : result.addNode(component));
        }
        return result;
    }

    protected Session openSession() throws RepositoryException {
        if (ObjectHelper.isEmpty((Object)this.getJcrEndpoint().getWorkspaceName())) {
            return this.getJcrEndpoint().getRepository().login(this.getJcrEndpoint().getCredentials());
        }
        return this.getJcrEndpoint().getRepository().login(this.getJcrEndpoint().getCredentials(), this.getJcrEndpoint().getWorkspaceName());
    }

    private JcrEndpoint getJcrEndpoint() {
        return (JcrEndpoint)this.getEndpoint();
    }
}

