/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.net.URI;
import java.net.URISyntaxException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jcr.JcrComponent;
import org.apache.camel.component.jcr.JcrProducer;
import org.apache.camel.impl.DefaultEndpoint;

public class JcrEndpoint
extends DefaultEndpoint {
    private Credentials credentials;
    private Repository repository;
    private String base;

    protected JcrEndpoint(String endpointUri, JcrComponent component) {
        super(endpointUri, (Component)component);
        try {
            String[] creds;
            URI uri = new URI(endpointUri);
            if (uri.getUserInfo() != null && (creds = uri.getUserInfo().split(":")) != null) {
                String username = creds[0];
                String password = creds.length > 1 ? creds[1] : null;
                this.credentials = new SimpleCredentials(username, password.toCharArray());
            }
            this.repository = (Repository)component.getCamelContext().getRegistry().lookup(uri.getHost(), Repository.class);
            if (this.repository == null) {
                throw new RuntimeCamelException("No JCR repository defined under '" + uri.getHost() + "'");
            }
            this.base = uri.getPath().replaceAll("^/", "");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + endpointUri, e);
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("No consumer endpoint support for JCR available");
    }

    public Producer createProducer() throws Exception {
        return new JcrProducer(this);
    }

    public boolean isSingleton() {
        return false;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected Credentials getCredentials() {
        return this.credentials;
    }

    protected String getBase() {
        return this.base;
    }
}

