/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jdbc.BeanRowMapper;
import org.apache.camel.util.IntrospectionSupport;

public final class JdbcHelper {
    private JdbcHelper() {
    }

    public static Object newBeanInstance(CamelContext camelContext, String outputClass, BeanRowMapper beanRowMapper, Map<String, Object> row) throws SQLException {
        Class clazz = camelContext.getClassResolver().resolveClass(outputClass);
        Object answer = camelContext.getInjector().newInstance(clazz);
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            Object value = entry.getValue();
            String name = beanRowMapper.map(entry.getKey(), value);
            properties.put(name, value);
        }
        try {
            IntrospectionSupport.setProperties((Object)answer, properties);
        }
        catch (Exception e) {
            throw new SQLException("Error setting properties on output class " + outputClass, e);
        }
        if (!properties.isEmpty()) {
            throw new IllegalArgumentException("Cannot map all properties to bean of type " + outputClass + ". There are " + properties.size() + " unmapped properties. " + properties);
        }
        return answer;
    }
}

