/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.component.jdbc.ConnectionStrategy;
import org.apache.camel.component.jdbc.JdbcEndpoint;
import org.apache.camel.component.jdbc.JdbcHelper;
import org.apache.camel.component.jdbc.JdbcOutputType;
import org.apache.camel.component.jdbc.ResultSetIterator;
import org.apache.camel.component.jdbc.StreamListIterator;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.SynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcProducer.class);
    private final DataSource dataSource;
    private final ConnectionStrategy connectionStrategy;
    private final int readSize;
    private final Map<String, Object> parameters;

    public JdbcProducer(JdbcEndpoint endpoint, DataSource dataSource, ConnectionStrategy connectionStrategy, int readSize, Map<String, Object> parameters) {
        super((Endpoint)endpoint);
        this.dataSource = dataSource;
        this.connectionStrategy = connectionStrategy;
        this.readSize = readSize;
        this.parameters = parameters;
    }

    public JdbcEndpoint getEndpoint() {
        return (JdbcEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        if (this.getEndpoint().isResetAutoCommit()) {
            this.processingSqlBySettingAutoCommit(exchange);
        } else {
            this.processingSqlWithoutSettingAutoCommit(exchange);
        }
    }

    private void processingSqlBySettingAutoCommit(Exchange exchange) throws Exception {
        block11: {
            boolean finalAutoCommit;
            Connection finalConn;
            String sql = (String)exchange.getIn().getBody(String.class);
            Connection conn = null;
            boolean autoCommit = false;
            boolean shouldCloseResources = true;
            try {
                conn = this.connectionStrategy.getConnection(this.dataSource);
                autoCommit = conn.getAutoCommit();
                if (autoCommit) {
                    conn.setAutoCommit(false);
                }
                shouldCloseResources = this.createAndExecuteSqlStatement(exchange, sql, conn);
                conn.commit();
                if (shouldCloseResources) {
                    this.resetAutoCommit(conn, autoCommit);
                    this.closeQuietly(conn);
                    break block11;
                }
                finalConn = conn;
                finalAutoCommit = autoCommit;
            }
            catch (Exception e) {
                try {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Throwable sqle) {
                        LOG.warn("Error occurred during JDBC rollback. This exception will be ignored.", sqle);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (shouldCloseResources) {
                        this.resetAutoCommit(conn, autoCommit);
                        this.closeQuietly(conn);
                    } else {
                        Connection finalConn2 = conn;
                        boolean finalAutoCommit2 = autoCommit;
                        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new SynchronizationAdapter(finalConn2, finalAutoCommit2){
                            final /* synthetic */ Connection val$finalConn;
                            final /* synthetic */ boolean val$finalAutoCommit;
                            {
                                this.val$finalConn = connection;
                                this.val$finalAutoCommit = bl;
                            }

                            public void onDone(Exchange exchange) {
                                JdbcProducer.this.resetAutoCommit(this.val$finalConn, this.val$finalAutoCommit);
                                JdbcProducer.this.closeQuietly(this.val$finalConn);
                            }

                            public int getOrder() {
                                return 2147482847;
                            }
                        });
                    }
                    throw throwable;
                }
            }
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new /* invalid duplicate definition of identical inner class */);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processingSqlWithoutSettingAutoCommit(Exchange exchange) throws Exception {
        block5: {
            Connection finalConn;
            String sql = (String)exchange.getIn().getBody(String.class);
            Connection conn = null;
            boolean shouldCloseResources = true;
            try {
                conn = this.connectionStrategy.getConnection(this.dataSource);
                shouldCloseResources = this.createAndExecuteSqlStatement(exchange, sql, conn);
                if (shouldCloseResources && !this.connectionStrategy.isConnectionTransactional(conn, this.dataSource)) {
                    this.closeQuietly(conn);
                    break block5;
                }
                finalConn = conn;
            }
            catch (Throwable throwable) {
                if (shouldCloseResources && !this.connectionStrategy.isConnectionTransactional(conn, this.dataSource)) {
                    this.closeQuietly(conn);
                } else {
                    Connection finalConn2 = conn;
                    ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new SynchronizationAdapter(finalConn2){
                        final /* synthetic */ Connection val$finalConn;
                        {
                            this.val$finalConn = connection;
                        }

                        public void onDone(Exchange exchange) {
                            JdbcProducer.this.closeQuietly(this.val$finalConn);
                        }

                        public int getOrder() {
                            return 2147482847;
                        }
                    });
                }
                throw throwable;
            }
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new /* invalid duplicate definition of identical inner class */);
        }
    }

    private boolean createAndExecuteSqlStatement(Exchange exchange, String sql, Connection conn) throws Exception {
        if (this.getEndpoint().isUseHeadersAsParameters()) {
            return this.doCreateAndExecuteSqlStatementWithHeaders(exchange, sql, conn);
        }
        return this.doCreateAndExecuteSqlStatement(exchange, sql, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doCreateAndExecuteSqlStatementWithHeaders(Exchange exchange, String sql, Connection conn) throws Exception {
        ResultSet finalRs;
        PreparedStatement finalPs;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean shouldCloseResources = true;
        try {
            String preparedQuery = this.getEndpoint().getPrepareStatementStrategy().prepareQuery(sql, this.getEndpoint().isAllowNamedParameters());
            boolean shouldRetrieveGeneratedKeys = (Boolean)exchange.getIn().getHeader("CamelRetrieveGeneratedKeys", (Object)false, Boolean.class);
            if (shouldRetrieveGeneratedKeys) {
                Object expectedGeneratedColumns = exchange.getIn().getHeader("CamelGeneratedColumns");
                if (expectedGeneratedColumns == null) {
                    ps = conn.prepareStatement(preparedQuery, 1);
                } else if (expectedGeneratedColumns instanceof String[]) {
                    ps = conn.prepareStatement(preparedQuery, (String[])expectedGeneratedColumns);
                } else {
                    if (!(expectedGeneratedColumns instanceof int[])) throw new IllegalArgumentException("Header specifying expected returning columns isn't an instance of String[] or int[] but " + expectedGeneratedColumns.getClass());
                    ps = conn.prepareStatement(preparedQuery, (int[])expectedGeneratedColumns);
                }
            } else {
                ps = conn.prepareStatement(preparedQuery);
            }
            this.bindParameters(exchange, ps);
            int expectedCount = ps.getParameterMetaData().getParameterCount();
            if (expectedCount > 0) {
                Iterator<?> it = this.getEndpoint().getPrepareStatementStrategy().createPopulateIterator(sql, preparedQuery, expectedCount, exchange, exchange.getIn().getBody());
                this.getEndpoint().getPrepareStatementStrategy().populateStatement(ps, it, expectedCount);
            }
            LOG.debug("Executing JDBC PreparedStatement: {}", (Object)sql);
            boolean stmtExecutionResult = ps.execute();
            if (stmtExecutionResult) {
                rs = ps.getResultSet();
                shouldCloseResources = this.setResultSet(exchange, conn, rs);
            } else {
                int updateCount = ps.getUpdateCount();
                exchange.getMessage().setHeader("CamelJdbcUpdateCount", (Object)updateCount);
            }
            if (shouldRetrieveGeneratedKeys) {
                this.setGeneratedKeys(exchange, conn, ps.getGeneratedKeys());
            }
            if (shouldCloseResources) {
                this.closeQuietly(rs);
                this.closeQuietly(ps);
                return shouldCloseResources;
            }
            finalPs = ps;
            finalRs = rs;
        }
        catch (Throwable throwable) {
            if (shouldCloseResources) {
                this.closeQuietly(rs);
                this.closeQuietly(ps);
                throw throwable;
            } else {
                PreparedStatement finalPs2 = ps;
                ResultSet finalRs2 = rs;
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new SynchronizationAdapter(finalRs2, finalPs2){
                    final /* synthetic */ ResultSet val$finalRs;
                    final /* synthetic */ Statement val$finalPs;
                    {
                        this.val$finalRs = resultSet;
                        this.val$finalPs = statement;
                    }

                    public void onDone(Exchange exchange) {
                        JdbcProducer.this.closeQuietly(this.val$finalRs);
                        JdbcProducer.this.closeQuietly(this.val$finalPs);
                    }

                    public int getOrder() {
                        return 2147482747;
                    }
                });
            }
            throw throwable;
        }
        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new /* invalid duplicate definition of identical inner class */);
        return shouldCloseResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doCreateAndExecuteSqlStatement(Exchange exchange, String sql, Connection conn) throws Exception {
        ResultSet finalRs;
        Statement finalStmt;
        Statement stmt = null;
        ResultSet rs = null;
        boolean shouldCloseResources = true;
        try {
            boolean stmtExecutionResult;
            stmt = conn.createStatement();
            this.bindParameters(exchange, stmt);
            LOG.debug("Executing JDBC Statement: {}", (Object)sql);
            boolean shouldRetrieveGeneratedKeys = (Boolean)exchange.getIn().getHeader("CamelRetrieveGeneratedKeys", (Object)false, Boolean.class);
            if (shouldRetrieveGeneratedKeys) {
                Object expectedGeneratedColumns = exchange.getIn().getHeader("CamelGeneratedColumns");
                if (expectedGeneratedColumns == null) {
                    stmtExecutionResult = stmt.execute(sql, 1);
                } else if (expectedGeneratedColumns instanceof String[]) {
                    stmtExecutionResult = stmt.execute(sql, (String[])expectedGeneratedColumns);
                } else {
                    if (!(expectedGeneratedColumns instanceof int[])) throw new IllegalArgumentException("Header specifying expected returning columns isn't an instance of String[] or int[] but " + expectedGeneratedColumns.getClass());
                    stmtExecutionResult = stmt.execute(sql, (int[])expectedGeneratedColumns);
                }
            } else {
                stmtExecutionResult = stmt.execute(sql);
            }
            if (stmtExecutionResult) {
                rs = stmt.getResultSet();
                shouldCloseResources = this.setResultSet(exchange, conn, rs);
            } else {
                int updateCount = stmt.getUpdateCount();
                exchange.getMessage().setHeader("CamelJdbcUpdateCount", (Object)updateCount);
            }
            if (shouldRetrieveGeneratedKeys) {
                this.setGeneratedKeys(exchange, conn, stmt.getGeneratedKeys());
            }
            if (shouldCloseResources) {
                this.closeQuietly(rs);
                this.closeQuietly(stmt);
                return shouldCloseResources;
            }
            finalStmt = stmt;
            finalRs = rs;
        }
        catch (Throwable throwable) {
            if (shouldCloseResources) {
                this.closeQuietly(rs);
                this.closeQuietly(stmt);
                throw throwable;
            } else {
                Statement finalStmt2 = stmt;
                ResultSet finalRs2 = rs;
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new SynchronizationAdapter(finalRs2, finalStmt2){
                    final /* synthetic */ ResultSet val$finalRs;
                    final /* synthetic */ Statement val$finalStmt;
                    {
                        this.val$finalRs = resultSet;
                        this.val$finalStmt = statement;
                    }

                    public void onDone(Exchange exchange) {
                        JdbcProducer.this.closeQuietly(this.val$finalRs);
                        JdbcProducer.this.closeQuietly(this.val$finalStmt);
                    }

                    public int getOrder() {
                        return 2147482747;
                    }
                });
            }
            throw throwable;
        }
        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new /* invalid duplicate definition of identical inner class */);
        return shouldCloseResources;
    }

    private void bindParameters(Exchange exchange, Statement stmt) {
        if (this.parameters != null && !this.parameters.isEmpty()) {
            HashMap<String, Object> copy = new HashMap<String, Object>(this.parameters);
            PropertyBindingSupport.bindProperties((CamelContext)exchange.getContext(), (Object)stmt, copy);
        }
    }

    private void closeQuietly(ResultSet rs) {
        if (rs != null) {
            try {
                if (!rs.isClosed()) {
                    rs.close();
                }
            }
            catch (Throwable sqle) {
                LOG.debug("Error by closing result set", sqle);
            }
        }
    }

    private void closeQuietly(Statement stmt) {
        if (stmt != null) {
            try {
                if (!stmt.isClosed()) {
                    stmt.close();
                }
            }
            catch (Throwable sqle) {
                LOG.debug("Error by closing statement", sqle);
            }
        }
    }

    private void resetAutoCommit(Connection con, boolean autoCommit) {
        if (con != null) {
            try {
                con.setAutoCommit(autoCommit);
            }
            catch (Throwable sqle) {
                LOG.debug("Error by resetting auto commit to its original value", sqle);
            }
        }
    }

    private void closeQuietly(Connection con) {
        if (con != null) {
            try {
                if (!con.isClosed()) {
                    con.close();
                }
            }
            catch (Throwable sqle) {
                LOG.debug("Error by closing connection", sqle);
            }
        }
    }

    protected void setGeneratedKeys(Exchange exchange, Connection conn, ResultSet generatedKeys) throws SQLException {
        if (generatedKeys != null) {
            ResultSetIterator iterator = new ResultSetIterator(conn, generatedKeys, this.getEndpoint().isUseJDBC4ColumnNameAndLabelSemantics(), this.getEndpoint().isUseGetBytesForBlob());
            List data = this.extractRows(iterator);
            exchange.getMessage().setHeader("CamelGeneratedKeysRowCount", (Object)data.size());
            exchange.getMessage().setHeader("CamelGeneratedKeysRows", (Object)data);
        }
    }

    protected boolean setResultSet(Exchange exchange, Connection conn, ResultSet rs) throws SQLException {
        boolean answer = true;
        ResultSetIterator iterator = new ResultSetIterator(conn, rs, this.getEndpoint().isUseJDBC4ColumnNameAndLabelSemantics(), this.getEndpoint().isUseGetBytesForBlob());
        JdbcOutputType outputType = this.getEndpoint().getOutputType();
        exchange.getMessage().setHeader("CamelJdbcColumnNames", iterator.getColumnNames());
        if (outputType == JdbcOutputType.StreamList) {
            exchange.getMessage().setBody((Object)new StreamListIterator(this.getEndpoint().getCamelContext(), this.getEndpoint().getOutputClass(), this.getEndpoint().getBeanRowMapper(), iterator));
            answer = false;
        } else if (outputType == JdbcOutputType.SelectList) {
            List list = this.extractRows(iterator);
            exchange.getMessage().setHeader("CamelJdbcRowCount", (Object)list.size());
            exchange.getMessage().setBody((Object)list);
        } else if (outputType == JdbcOutputType.SelectOne) {
            exchange.getMessage().setBody(this.extractSingleRow(iterator));
        }
        return answer;
    }

    private List extractRows(ResultSetIterator iterator) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        int maxRowCount = this.readSize == 0 ? Integer.MAX_VALUE : this.readSize;
        for (int i = 0; iterator.hasNext() && i < maxRowCount; ++i) {
            Object row = iterator.next();
            Object value = this.getEndpoint().getOutputClass() != null ? JdbcHelper.newBeanInstance(this.getEndpoint().getCamelContext(), this.getEndpoint().getOutputClass(), this.getEndpoint().getBeanRowMapper(), (Map<String, Object>)row) : row;
            result.add(value);
        }
        return result;
    }

    private Object extractSingleRow(ResultSetIterator iterator) throws SQLException {
        if (!iterator.hasNext()) {
            return null;
        }
        Object row = iterator.next();
        if (iterator.hasNext()) {
            throw new SQLDataException("Query result not unique for outputType=SelectOne.");
        }
        if (this.getEndpoint().getOutputClass() != null) {
            return JdbcHelper.newBeanInstance(this.getEndpoint().getCamelContext(), this.getEndpoint().getOutputClass(), this.getEndpoint().getBeanRowMapper(), (Map<String, Object>)row);
        }
        if (row.size() == 1) {
            return row.values().iterator().next();
        }
        return row;
    }
}

