/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty9;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class JettyHttp9EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":httpUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "jetty".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "httpUri", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(33);
        props.add("async");
        props.add("bridgeErrorHandler");
        props.add("chunked");
        props.add("continuationTimeout");
        props.add("disableStreamCache");
        props.add("eagerCheckContentAvailable");
        props.add("enableCORS");
        props.add("enableJmx");
        props.add("enableMultipartFilter");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("filterInitParameters");
        props.add("filters");
        props.add("handlers");
        props.add("headerFilterStrategy");
        props.add("httpBinding");
        props.add("httpMethodRestrict");
        props.add("httpUri");
        props.add("mapHttpMessageBody");
        props.add("mapHttpMessageFormUrlEncodedBody");
        props.add("mapHttpMessageHeaders");
        props.add("matchOnUriPrefix");
        props.add("multipartFilter");
        props.add("muteException");
        props.add("optionsEnabled");
        props.add("responseBufferSize");
        props.add("sendDateHeader");
        props.add("sendServerVersion");
        props.add("sessionSupport");
        props.add("sslContextParameters");
        props.add("traceEnabled");
        props.add("transferException");
        props.add("useContinuation");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("filter.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

