/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.raft.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.jgroups.raft.cluster.ClusterRoleChangeListener;
import org.apache.camel.component.jgroups.raft.utils.NopStateMachine;
import org.apache.camel.impl.cluster.AbstractCamelClusterView;
import org.jgroups.JChannel;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.StateMachine;
import org.jgroups.raft.RaftHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsRaftClusterView
extends AbstractCamelClusterView {
    private static final transient Logger LOG = LoggerFactory.getLogger(JGroupsRaftClusterView.class);
    private final CamelClusterMember localMember = new JGropusraftLocalMember();
    private String jgroupsConfig;
    private String jgroupsClusterName;
    private RaftHandle raftHandle;
    private String raftId;
    private volatile boolean isMaster;

    protected JGroupsRaftClusterView(CamelClusterService cluster, String namespace, String jgroupsConfig, String jgroupsClusterName, RaftHandle raftHandle, String raftId) {
        super(cluster, namespace);
        this.jgroupsConfig = jgroupsConfig;
        this.jgroupsClusterName = jgroupsClusterName;
        this.raftHandle = raftHandle;
        this.raftId = raftId;
    }

    public Optional<CamelClusterMember> getLeader() {
        if (this.isMaster) {
            return Optional.of(this.localMember);
        }
        return Optional.empty();
    }

    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    public List<CamelClusterMember> getMembers() {
        return new ArrayList<CamelClusterMember>(){
            {
                this.add(JGroupsRaftClusterView.this.localMember);
            }
        };
    }

    protected void doStart() throws Exception {
        if (this.raftHandle == null && this.jgroupsConfig != null && !this.jgroupsConfig.isEmpty()) {
            this.raftHandle = new RaftHandle(new JChannel(this.jgroupsConfig), (StateMachine)new NopStateMachine()).raftId(this.raftId);
        } else if (this.raftHandle == null) {
            this.raftHandle = new RaftHandle(new JChannel("raft.xml"), (StateMachine)new NopStateMachine()).raftId(this.raftId);
        }
        this.fireLeadershipChangedEvent(Optional.empty());
        this.raftHandle.addRoleListener((RAFT.RoleChange)new ClusterRoleChangeListener(this));
        this.raftHandle.channel().connect(this.jgroupsClusterName);
    }

    protected void doStop() throws Exception {
        this.isMaster = false;
        this.fireLeadershipChangedEvent(Optional.empty());
        LOG.info("Disconnecting JGroupsraft Channel for JGroupsRaftClusterView with Id {}", (Object)this.raftId);
        this.raftHandle.channel().disconnect();
        if (this.raftHandle != null && this.raftHandle.log() != null) {
            this.raftHandle.log().close();
            LOG.info("Closed Log for JGroupsRaftClusterView with Id {}", (Object)this.raftId);
        }
    }

    protected void doShutdown() throws Exception {
        this.isMaster = false;
        this.fireLeadershipChangedEvent(Optional.empty());
        if (this.raftHandle != null) {
            this.raftHandle.channel().close();
            this.raftHandle = null;
        }
        LOG.info("Closing JGroupsraft Channel for JGroupsRaftClusterView with Id {}", (Object)this.raftId);
        if (this.raftHandle != null && this.raftHandle.channel() != null) {
            this.raftHandle.channel().close();
            LOG.info("Closed JGroupsraft Channel Channel for JGroupsRaftClusterView with Id {}", (Object)this.raftId);
        }
        LOG.info("Closing Log for JGroupsRaftClusterView with Id {}", (Object)this.raftId);
        if (this.raftHandle != null && this.raftHandle.log() != null) {
            this.raftHandle.log().close();
            LOG.info("Closed Log for JGroupsRaftClusterView with Id {}", (Object)this.raftId);
        }
        this.raftHandle = null;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean master) {
        this.isMaster = master;
    }

    protected void fireLeadershipChangedEvent(Optional<CamelClusterMember> leader) {
        super.fireLeadershipChangedEvent(leader);
    }

    private final class JGropusraftLocalMember
    implements CamelClusterMember {
        private JGropusraftLocalMember() {
        }

        public boolean isLeader() {
            return JGroupsRaftClusterView.this.isMaster;
        }

        public boolean isLocal() {
            return true;
        }

        public String getId() {
            return JGroupsRaftClusterView.this.getClusterService().getId();
        }
    }
}

