/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.input.IssueInputBuilder;
import org.apache.camel.Exchange;
import org.apache.camel.component.jira.JIRAEndpoint;
import org.apache.camel.component.jira.producer.AbstractJIRAProducer;

public class NewIssueProducer
extends AbstractJIRAProducer {
    public NewIssueProducer(JIRAEndpoint endpoint) throws Exception {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String projectKey = (String)exchange.getIn().getHeader("ProjectKey", String.class);
        Long issueTypeId = (Long)exchange.getIn().getHeader("IssueTypeId", Long.class);
        String issueSummary = (String)exchange.getIn().getHeader("IssueSummary", String.class);
        IssueInputBuilder issueBuilder = new IssueInputBuilder(projectKey, issueTypeId);
        issueBuilder.setDescription((String)exchange.getIn().getBody(String.class));
        issueBuilder.setSummary(issueSummary);
        BasicIssue issue = this.client().getIssueClient().createIssue(issueBuilder.build(), null);
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody((Object)issue);
        } else {
            exchange.getIn().setBody((Object)issue);
        }
    }
}

