/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Issue;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.component.jira.consumer.AbstractJiraConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchUpdatesConsumer
extends AbstractJiraConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(WatchUpdatesConsumer.class);
    final HashMap<Long, Issue> watchedIssues = new HashMap();
    List<String> watchedFieldsList = new ArrayList<String>();
    String watchedIssuesKeys;

    public WatchUpdatesConsumer(JiraEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.watchedFieldsList = Arrays.asList(endpoint.getWatchedFields().split(","));
    }

    protected void doStart() throws Exception {
        super.doStart();
        Queue<Issue> issues = this.getIssues(this.getEndpoint().getJql());
        this.initIssues(issues);
    }

    private void initIssues(Collection<Issue> issues) {
        this.watchedIssues.clear();
        issues.forEach(i -> this.watchedIssues.put(i.getId(), (Issue)i));
        this.watchedIssuesKeys = issues.stream().map(BasicIssue::getKey).collect(Collectors.joining(","));
    }

    @Override
    protected int doPoll() throws Exception {
        Queue<Issue> issues = this.getIssues();
        for (Issue issue : issues) {
            this.checkIfIssueChanged(issue);
        }
        if (this.watchedIssues.values().size() != issues.size()) {
            this.initIssues(issues);
        }
        return 0;
    }

    private void checkIfIssueChanged(Issue issue) throws Exception {
        Issue original = this.watchedIssues.get(issue.getId());
        if (original != null) {
            boolean issueChanged = false;
            for (String field : this.watchedFieldsList) {
                issueChanged |= this.hasFieldChanged(issue, original, field);
            }
            if (issueChanged) {
                this.watchedIssues.put(issue.getId(), issue);
            }
        }
    }

    private boolean hasFieldChanged(Issue changed, Issue original, String fieldName) throws Exception {
        Object changedField;
        Method get = Issue.class.getDeclaredMethod("get" + fieldName, new Class[0]);
        Object originalField = get.invoke((Object)original, new Object[0]);
        if (!Objects.equals(originalField, changedField = get.invoke((Object)changed, new Object[0]))) {
            if (!this.getEndpoint().isSendOnlyUpdatedField()) {
                this.processExchange(changed, changed.getKey(), fieldName);
            } else {
                this.processExchange(changedField, changed.getKey(), fieldName);
            }
            return true;
        }
        return false;
    }

    private void processExchange(Object body, String issueKey, String changed) throws Exception {
        Exchange e = this.createExchange(true);
        e.getIn().setBody(body);
        e.getIn().setHeader("IssueKey", (Object)issueKey);
        e.getIn().setHeader("IssueChanged", (Object)changed);
        e.getIn().setHeader("IssueWatchedIssues", (Object)this.watchedIssuesKeys);
        LOG.debug(" {}: {} changed to {}", new Object[]{issueKey, changed, body});
        this.getProcessor().process(e);
    }
}

