/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira;

import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClientFactory;
import java.net.URI;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jira.JiraComponent;
import org.apache.camel.component.jira.JiraConfiguration;
import org.apache.camel.component.jira.JiraConstants;
import org.apache.camel.component.jira.JiraType;
import org.apache.camel.component.jira.consumer.AbstractJiraConsumer;
import org.apache.camel.component.jira.consumer.NewCommentsConsumer;
import org.apache.camel.component.jira.consumer.NewIssuesConsumer;
import org.apache.camel.component.jira.consumer.WatchUpdatesConsumer;
import org.apache.camel.component.jira.oauth.JiraOAuthAuthenticationHandler;
import org.apache.camel.component.jira.oauth.OAuthAsynchronousJiraRestClientFactory;
import org.apache.camel.component.jira.producer.AddCommentProducer;
import org.apache.camel.component.jira.producer.AddIssueLinkProducer;
import org.apache.camel.component.jira.producer.AddIssueProducer;
import org.apache.camel.component.jira.producer.AddWorkLogProducer;
import org.apache.camel.component.jira.producer.AttachFileProducer;
import org.apache.camel.component.jira.producer.DeleteIssueProducer;
import org.apache.camel.component.jira.producer.FetchCommentsProducer;
import org.apache.camel.component.jira.producer.FetchIssueProducer;
import org.apache.camel.component.jira.producer.TransitionIssueProducer;
import org.apache.camel.component.jira.producer.UpdateIssueProducer;
import org.apache.camel.component.jira.producer.WatcherProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.0", scheme="jira", title="Jira", syntax="jira:type", category={Category.DOCUMENT}, headersClass=JiraConstants.class)
public class JiraEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    private static final Logger LOG = LoggerFactory.getLogger(JiraEndpoint.class);
    @UriPath
    @Metadata(required=true)
    private JiraType type;
    @UriParam(label="consumer")
    private String jql;
    @UriParam(label="consumer", defaultValue="Status,Priority")
    private String watchedFields = "Status,Priority";
    @UriParam(label="consumer", defaultValue="true")
    private boolean sendOnlyUpdatedField = true;
    @UriParam(label="consumer", defaultValue="50")
    private Integer maxResults = 50;
    @UriParam
    private JiraConfiguration configuration;
    private transient JiraRestClient client;

    public JiraEndpoint(String uri, JiraComponent component, JiraConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public String getServiceUrl() {
        return this.configuration.getJiraUrl();
    }

    public String getServiceProtocol() {
        return "rest";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getUsername() != null) {
            return Map.of("username", this.configuration.getUsername());
        }
        return null;
    }

    public JiraConfiguration getConfiguration() {
        return this.configuration;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.connect();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.disconnect();
    }

    public synchronized void connect() {
        if (this.client == null) {
            Registry registry = this.getCamelContext().getRegistry();
            Object factory = (JiraRestClientFactory)registry.lookupByNameAndType("JiraRestClientFactory", JiraRestClientFactory.class);
            if (factory == null) {
                factory = new OAuthAsynchronousJiraRestClientFactory();
            }
            URI jiraServerUri = URI.create(this.configuration.getJiraUrl());
            if (this.configuration.getUsername() != null) {
                LOG.debug("Connecting to JIRA with Basic authentication with username/password");
                this.client = factory.createWithBasicHttpAuthentication(jiraServerUri, this.configuration.getUsername(), this.configuration.getPassword());
            } else if (this.configuration.getAccessToken() != null && this.configuration.getVerificationCode() == null && this.configuration.getPrivateKey() == null && this.configuration.getConsumerKey() == null) {
                this.client = factory.create(jiraServerUri, builder -> builder.setHeader("Authorization", "Bearer " + this.configuration.getAccessToken()));
            } else {
                LOG.debug("Connecting to JIRA with OAuth authentication");
                JiraOAuthAuthenticationHandler oAuthHandler = new JiraOAuthAuthenticationHandler(this.configuration.getConsumerKey(), this.configuration.getVerificationCode(), this.configuration.getPrivateKey(), this.configuration.getAccessToken(), this.configuration.getJiraUrl());
                this.client = factory.create(jiraServerUri, (AuthenticationHandler)oAuthHandler);
            }
        }
    }

    public synchronized void disconnect() throws Exception {
        if (this.client != null) {
            LOG.debug("Disconnecting from JIRA");
            this.client.close();
            this.client = null;
        }
    }

    public Producer createProducer() {
        return switch (this.type) {
            case JiraType.ADDISSUE -> new AddIssueProducer(this);
            case JiraType.ATTACH -> new AttachFileProducer(this);
            case JiraType.ADDCOMMENT -> new AddCommentProducer(this);
            case JiraType.WATCHERS -> new WatcherProducer(this);
            case JiraType.DELETEISSUE -> new DeleteIssueProducer(this);
            case JiraType.UPDATEISSUE -> new UpdateIssueProducer(this);
            case JiraType.TRANSITIONISSUE -> new TransitionIssueProducer(this);
            case JiraType.ADDISSUELINK -> new AddIssueLinkProducer(this);
            case JiraType.ADDWORKLOG -> new AddWorkLogProducer(this);
            case JiraType.FETCHISSUE -> new FetchIssueProducer(this);
            case JiraType.FETCHCOMMENTS -> new FetchCommentsProducer(this);
            default -> throw new IllegalArgumentException("Producer does not support type: " + String.valueOf((Object)this.type));
        };
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        AbstractJiraConsumer consumer;
        if (this.type == JiraType.NEWCOMMENTS) {
            consumer = new NewCommentsConsumer(this, processor);
        } else if (this.type == JiraType.NEWISSUES) {
            consumer = new NewIssuesConsumer(this, processor);
        } else if (this.type == JiraType.WATCHUPDATES) {
            consumer = new WatchUpdatesConsumer(this, processor);
        } else {
            throw new IllegalArgumentException("Consumer does not support type: " + String.valueOf((Object)this.type));
        }
        consumer.setMaxMessagesPerPoll(this.getMaxResults());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public JiraType getType() {
        return this.type;
    }

    public void setType(JiraType type) {
        this.type = type;
    }

    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public long getDelay() {
        return this.configuration.getDelay().intValue();
    }

    public JiraRestClient getClient() {
        this.connect();
        return this.client;
    }

    public void setClient(JiraRestClient client) {
        this.client = client;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public String getWatchedFields() {
        return this.watchedFields;
    }

    public void setWatchedFields(String watchChange) {
        this.watchedFields = watchChange;
    }

    public boolean isSendOnlyUpdatedField() {
        return this.sendOnlyUpdatedField;
    }

    public void setSendOnlyUpdatedField(boolean sendOnlyUpdatedField) {
        this.sendOnlyUpdatedField = sendOnlyUpdatedField;
    }
}

