/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import java.math.BigInteger;
import java.util.Random;
import java.util.concurrent.Executor;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.DefaultSpringErrorHandler;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.component.jms.reply.ExclusiveQueueMessageListenerContainer;
import org.apache.camel.component.jms.reply.ExclusiveQueueSimpleMessageListenerContainer;
import org.apache.camel.component.jms.reply.MessageSelectorCreator;
import org.apache.camel.component.jms.reply.QueueReplyHandler;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.component.jms.reply.ReplyManagerSupport;
import org.apache.camel.component.jms.reply.SharedQueueMessageListenerContainer;
import org.apache.camel.component.jms.reply.SharedQueueSimpleMessageListenerContainer;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.ErrorHandler;

public class QueueReplyManager
extends ReplyManagerSupport {
    private String replyToSelectorValue;

    public QueueReplyManager(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    protected ReplyHandler createReplyHandler(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        return new QueueReplyHandler(replyManager, exchange, callback, originalCorrelationId, correlationId, requestTimeout);
    }

    @Override
    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        this.log.trace("Updated provisional correlationId [{}] to expected correlationId [{}]", (Object)correlationId, (Object)newCorrelationId);
        ReplyHandler handler = (ReplyHandler)this.correlation.remove(correlationId);
        if (handler == null) {
            return;
        }
        this.correlation.put(newCorrelationId, handler, requestTimeout);
    }

    @Override
    protected void handleReplyMessage(String correlationID, jakarta.jms.Message message, Session session) {
        ReplyHandler handler = (ReplyHandler)this.correlation.remove(correlationID);
        if (handler == null && this.endpoint.isUseMessageIDAsCorrelationID()) {
            handler = this.waitForProvisionCorrelationToBeUpdated(correlationID, message);
        }
        if (handler != null) {
            handler.onReply(correlationID, message, session);
        } else {
            this.log.warn("Reply received for unknown correlationID [{}] on reply destination [{}]. Current correlation map size: {}. The message will be ignored: {}", new Object[]{correlationID, this.replyTo, this.correlation.size(), message});
        }
    }

    @Override
    public void setReplyToSelectorHeader(Message camelMessage, jakarta.jms.Message jmsMessage) throws JMSException {
        String replyToSelectorName = this.endpoint.getReplyToDestinationSelectorName();
        if (replyToSelectorName != null && this.replyToSelectorValue != null) {
            camelMessage.setHeader(replyToSelectorName, (Object)this.replyToSelectorValue);
            jmsMessage.setStringProperty(replyToSelectorName, this.replyToSelectorValue);
        }
    }

    @Override
    protected AbstractMessageListenerContainer createListenerContainer() throws Exception {
        if (this.endpoint.getConfiguration().getReplyToConsumerType() == ConsumerType.Default) {
            return this.createDefaultListenerContainer();
        }
        if (this.endpoint.getConfiguration().getReplyToConsumerType() == ConsumerType.Simple) {
            return this.createSimpleListenerContainer();
        }
        return QueueReplyManager.getAbstractMessageListenerContainer(this.endpoint);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractMessageListenerContainer createSimpleListenerContainer() {
        void var1_6;
        ReplyToType type = this.endpoint.getConfiguration().getReplyToType();
        if (type == null) {
            type = ReplyToType.Shared;
        }
        if (ReplyToType.Shared == type) {
            String replyToSelectorName = this.endpoint.getReplyToDestinationSelectorName();
            if (replyToSelectorName == null) throw new IllegalArgumentException("ReplyToDestinationSelectorName must be configured when using Simple ReplyToConsumerType");
            this.replyToSelectorValue = "ID:" + new BigInteger(192, new Random()).toString(16);
            String fixedMessageSelector = replyToSelectorName + "='" + this.replyToSelectorValue + "'";
            SharedQueueSimpleMessageListenerContainer sharedQueueSimpleMessageListenerContainer = new SharedQueueSimpleMessageListenerContainer(this.endpoint, fixedMessageSelector);
            this.log.debug("Using shared queue: {} with fixed message selector [{}] as reply listener: {}", new Object[]{this.endpoint.getReplyTo(), fixedMessageSelector, sharedQueueSimpleMessageListenerContainer});
        } else {
            if (ReplyToType.Exclusive != type) throw new IllegalArgumentException("ReplyToType " + type + " is not supported for reply queues");
            ExclusiveQueueSimpleMessageListenerContainer exclusiveQueueSimpleMessageListenerContainer = new ExclusiveQueueSimpleMessageListenerContainer(this.endpoint);
            this.log.debug("Using exclusive queue: {} as reply listener: {}", (Object)this.endpoint.getReplyTo(), (Object)exclusiveQueueSimpleMessageListenerContainer);
        }
        DestinationResolver resolver = this.endpoint.getDestinationResolver();
        if (resolver == null) {
            resolver = var1_6.getDestinationResolver();
        }
        var1_6.setDestinationResolver((DestinationResolver)new DestinationResolverDelegate(resolver));
        var1_6.setDestinationName(this.endpoint.getReplyTo());
        var1_6.setAutoStartup(true);
        var1_6.setMessageListener((Object)this);
        var1_6.setPubSubDomain(false);
        var1_6.setSubscriptionDurable(false);
        var1_6.setConcurrentConsumers(this.endpoint.getReplyToConcurrentConsumers());
        var1_6.setConnectionFactory(this.endpoint.getConfiguration().getOrCreateConnectionFactory());
        Object clientId = this.endpoint.getClientId();
        if (clientId != null) {
            clientId = (String)clientId + ".CamelReplyManager";
            var1_6.setClientId((String)clientId);
        }
        var1_6.setSessionTransacted(false);
        this.setOptionalProperties(var1_6);
        if (this.endpoint.getTaskExecutor() != null) {
            this.log.debug("Using custom TaskExecutor: {} on listener container: {}", (Object)this.endpoint.getTaskExecutor(), (Object)var1_6);
            var1_6.setTaskExecutor((Executor)this.endpoint.getTaskExecutor());
        }
        String name = "QueueReplyManager[" + var1_6.getDestinationName() + "]";
        var1_6.setBeanName(name);
        if (this.endpoint.getReplyToConcurrentConsumers() <= 1) return var1_6;
        if (ReplyToType.Shared == type) {
            this.log.warn("Using {} concurrent consumer on {} with shared queue {} may not work properly with all message brokers.", new Object[]{this.endpoint.getReplyToConcurrentConsumers(), name, this.endpoint.getReplyTo()});
            return var1_6;
        } else {
            this.log.info("Using {} concurrent consumers on {}", (Object)this.endpoint.getReplyToConcurrentConsumers(), (Object)name);
        }
        return var1_6;
    }

    protected DefaultMessageListenerContainer createDefaultListenerContainer() throws Exception {
        DestinationResolver resolver;
        DefaultJmsMessageListenerContainer answer;
        ReplyToType type = this.endpoint.getConfiguration().getReplyToType();
        if (type == null) {
            type = ReplyToType.Shared;
        }
        if (ReplyToType.Shared == type) {
            String replyToSelectorName = this.endpoint.getReplyToDestinationSelectorName();
            if (replyToSelectorName != null) {
                this.replyToSelectorValue = "ID:" + new BigInteger(192, new Random()).toString(16);
                String fixedMessageSelector = replyToSelectorName + "='" + this.replyToSelectorValue + "'";
                answer = new SharedQueueMessageListenerContainer(this.endpoint, fixedMessageSelector);
                this.log.debug("Using shared queue: {} with fixed message selector [{}] as reply listener: {}", new Object[]{this.endpoint.getReplyTo(), fixedMessageSelector, answer});
            } else {
                MessageSelectorCreator dynamicMessageSelector = new MessageSelectorCreator(this.correlation);
                answer = new SharedQueueMessageListenerContainer(this.endpoint, dynamicMessageSelector);
                this.log.debug("Using shared queue: {} with dynamic message selector as reply listener: {}", (Object)this.endpoint.getReplyTo(), (Object)answer);
            }
            this.log.warn("{} is using a shared reply queue, which is not as fast as alternatives. See more detail at the section 'Request-reply over JMS' in the JMS component documentation", (Object)this.endpoint);
        } else if (ReplyToType.Exclusive == type) {
            answer = new ExclusiveQueueMessageListenerContainer(this.endpoint);
            this.log.debug("Using exclusive queue: {} as reply listener: {}", (Object)this.endpoint.getReplyTo(), (Object)answer);
        } else {
            throw new IllegalArgumentException("ReplyToType " + type + " is not supported for reply queues");
        }
        String replyToCacheLevelName = this.endpoint.getConfiguration().getReplyToCacheLevelName();
        if (replyToCacheLevelName != null) {
            answer.setCacheLevelName(replyToCacheLevelName);
            this.log.debug("Setting the replyCacheLevel to be {}", (Object)replyToCacheLevelName);
        }
        if ((resolver = this.endpoint.getDestinationResolver()) == null) {
            resolver = answer.getDestinationResolver();
        }
        answer.setDestinationResolver(new DestinationResolverDelegate(resolver));
        answer.setDestinationName(this.endpoint.getReplyTo());
        answer.setAutoStartup(true);
        answer.setIdleConsumerLimit(this.endpoint.getIdleConsumerLimit());
        answer.setIdleTaskExecutionLimit(this.endpoint.getIdleTaskExecutionLimit());
        if (this.endpoint.getMaxMessagesPerTask() >= 0) {
            answer.setMaxMessagesPerTask(this.endpoint.getMaxMessagesPerTask());
        }
        if (this.endpoint.getIdleReceivesPerTaskLimit() != 0) {
            answer.setIdleReceivesPerTaskLimit(this.endpoint.getIdleReceivesPerTaskLimit());
        }
        answer.setMessageListener(this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(this.endpoint.getReplyToConcurrentConsumers());
        if (this.endpoint.getReplyToMaxConcurrentConsumers() > 0) {
            answer.setMaxConcurrentConsumers(this.endpoint.getReplyToMaxConcurrentConsumers());
        }
        answer.setConnectionFactory(this.endpoint.getConfiguration().getOrCreateConnectionFactory());
        QueueReplyManager.setupClientId(this.endpoint, answer);
        answer.setSessionTransacted(false);
        this.setOptionalProperties(answer);
        if (this.endpoint.getReceiveTimeout() >= 0L) {
            answer.setReceiveTimeout(this.endpoint.getReceiveTimeout());
        }
        if (this.endpoint.getRecoveryInterval() >= 0L) {
            answer.setRecoveryInterval(this.endpoint.getRecoveryInterval());
        }
        if (this.endpoint.getTaskExecutor() != null) {
            this.log.debug("Using custom TaskExecutor: {} on listener container: {}", (Object)this.endpoint.getTaskExecutor(), (Object)answer);
            answer.setTaskExecutor((Executor)this.endpoint.getTaskExecutor());
        }
        String name = "QueueReplyManager[" + answer.getDestinationName() + "]";
        answer.setBeanName(name);
        if (answer.getConcurrentConsumers() > 1) {
            if (ReplyToType.Shared == type) {
                this.log.warn("Using {}-{} concurrent consumer on {} with shared queue {} may not work properly with all message brokers.", new Object[]{answer.getConcurrentConsumers(), answer.getMaxConcurrentConsumers(), name, this.endpoint.getReplyTo()});
            } else {
                this.log.info("Using {}-{} concurrent consumers on {}", new Object[]{answer.getConcurrentConsumers(), answer.getMaxConcurrentConsumers(), name});
            }
        }
        return answer;
    }

    private <T extends AbstractMessageListenerContainer> void setOptionalProperties(T answer) {
        if (this.endpoint.getExceptionListener() != null) {
            answer.setExceptionListener(this.endpoint.getExceptionListener());
        }
        if (this.endpoint.getErrorHandler() != null) {
            answer.setErrorHandler(this.endpoint.getErrorHandler());
        } else {
            answer.setErrorHandler((ErrorHandler)new DefaultSpringErrorHandler(this.endpoint.getCamelContext(), QueueReplyManager.class, this.endpoint.getErrorHandlerLoggingLevel(), this.endpoint.isErrorHandlerLogStackTrace()));
        }
    }

    private final class DestinationResolverDelegate
    implements DestinationResolver {
        private final DestinationResolver delegate;
        private Destination destination;

        DestinationResolverDelegate(DestinationResolver delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
            QueueReplyManager.this.lock.lock();
            try {
                if (this.destination == null) {
                    this.destination = this.delegate.resolveDestinationName(session, destinationName, pubSubDomain);
                    QueueReplyManager.this.setReplyTo(this.destination);
                }
            }
            finally {
                QueueReplyManager.this.lock.unlock();
            }
            return this.destination;
        }
    }
}

