/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.ThreadFactory;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.JmsException;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DefaultJmsMessageListenerContainer
extends DefaultMessageListenerContainer {
    private final JmsEndpoint endpoint;
    private final boolean allowQuickStop;
    private volatile TaskExecutor taskExecutor;

    public DefaultJmsMessageListenerContainer(JmsEndpoint endpoint) {
        this(endpoint, true);
    }

    public DefaultJmsMessageListenerContainer(JmsEndpoint endpoint, boolean allowQuickStop) {
        this.endpoint = endpoint;
        this.allowQuickStop = allowQuickStop;
    }

    protected boolean isAllowQuickStop() {
        return this.allowQuickStop;
    }

    protected boolean runningAllowed() {
        boolean quickStop = false;
        if (this.isAllowQuickStop() && !this.endpoint.isAcceptMessagesWhileStopping()) {
            quickStop = this.endpoint.getCamelContext().getStatus().isStopping();
        }
        if (quickStop) {
            this.logger.debug((Object)"runningAllowed() -> false due CamelContext is stopping and endpoint configured to not accept messages while stopping");
            return false;
        }
        boolean answer = this.endpoint.isRunning();
        this.logger.trace((Object)("runningAllowed() -> " + answer));
        return answer;
    }

    protected TaskExecutor createDefaultTaskExecutor() {
        String pattern = this.endpoint.getCamelContext().getExecutorServiceManager().getThreadNamePattern();
        String beanName = this.getBeanName() == null ? this.endpoint.getThreadName() : this.getBeanName();
        TaskExecutor answer = this.endpoint.getDefaultTaskExecutorType() == DefaultTaskExecutorType.ThreadPool ? this.createThreadPoolExecutor(beanName, pattern) : DefaultJmsMessageListenerContainer.createAsyncTaskExecutor(beanName, pattern);
        this.taskExecutor = answer;
        return answer;
    }

    private static TaskExecutor createAsyncTaskExecutor(String beanName, String pattern) {
        SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor(beanName);
        executor.setThreadFactory((ThreadFactory)new CamelThreadFactory(pattern, beanName, true));
        return executor;
    }

    private TaskExecutor createThreadPoolExecutor(String beanName, String pattern) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setBeanName(beanName);
        executor.setThreadFactory((ThreadFactory)new CamelThreadFactory(pattern, beanName, true));
        executor.setCorePoolSize(this.endpoint.getConcurrentConsumers());
        executor.setQueueCapacity(0);
        executor.initialize();
        return executor;
    }

    public void stop() throws JmsException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Stopping listenerContainer: " + this + " with cacheLevel: " + this.getCacheLevel() + " and sharedConnectionEnabled: " + this.sharedConnectionEnabled()));
        }
        super.stop();
        if (this.taskExecutor instanceof ThreadPoolTaskExecutor) {
            ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)this.taskExecutor;
            executor.destroy();
        }
    }

    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Destroying listenerContainer: " + this + " with cacheLevel: " + this.getCacheLevel() + " and sharedConnectionEnabled: " + this.sharedConnectionEnabled()));
        }
        super.destroy();
        if (this.taskExecutor instanceof ThreadPoolTaskExecutor) {
            ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)this.taskExecutor;
            executor.destroy();
        }
    }

    protected void stopSharedConnection() {
        if (this.logger.isDebugEnabled() && this.sharedConnectionEnabled()) {
            this.logger.debug((Object)("Stopping shared connection on listenerContainer: " + this));
        }
        super.stopSharedConnection();
    }
}

