/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.monitor.MonitorNotification;
import javax.management.remote.JMXConnectionNotification;
import javax.management.timer.TimerNotification;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.camel.component.jmx.NotificationFormatException;
import org.apache.camel.component.jmx.jaxb.NotificationEventType;
import org.apache.camel.component.jmx.jaxb.ObjectFactory;
import org.apache.camel.component.jmx.jaxb.ObjectNamesType;
import org.apache.camel.component.jmx.jaxb.RelationNotification;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationXmlFormatter
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationXmlFormatter.class);
    private final ObjectFactory mObjectFactory = new ObjectFactory();
    private JAXBContext jaxbContext;
    private DatatypeFactory mDatatypeFactory;

    public String format(Notification aNotification) throws NotificationFormatException {
        NotificationEventType jaxb;
        ObjectHelper.notNull((Object)this.jaxbContext, (String)"jaxbContext");
        boolean wrap = false;
        if (aNotification instanceof AttributeChangeNotification) {
            AttributeChangeNotification ac = (AttributeChangeNotification)aNotification;
            jaxb = this.mObjectFactory.createAttributeChangeNotification().withAttributeName(ac.getAttributeName()).withAttributeType(ac.getAttributeType()).withNewValue(ac.getNewValue() == null ? null : String.valueOf(ac.getNewValue())).withOldValue(ac.getOldValue() == null ? null : String.valueOf(ac.getOldValue()));
        } else if (aNotification instanceof JMXConnectionNotification) {
            jaxb = this.mObjectFactory.createJMXConnectionNotification().withConnectionId(((JMXConnectionNotification)aNotification).getConnectionId());
        } else if (aNotification instanceof MBeanServerNotification) {
            jaxb = this.mObjectFactory.createMBeanServerNotification().withMBeanName(String.valueOf(((MBeanServerNotification)aNotification).getMBeanName()));
        } else if (aNotification instanceof MonitorNotification) {
            MonitorNotification mn = (MonitorNotification)aNotification;
            jaxb = this.mObjectFactory.createMonitorNotification().withDerivedGauge(String.valueOf(mn.getDerivedGauge())).withObservedAttribute(mn.getObservedAttribute()).withObservedObject(String.valueOf(mn.getObservedObject())).withTrigger(String.valueOf(mn.getTrigger()));
        } else if (aNotification instanceof javax.management.relation.RelationNotification) {
            ObjectNamesType ont;
            javax.management.relation.RelationNotification rn = (javax.management.relation.RelationNotification)aNotification;
            jaxb = this.mObjectFactory.createRelationNotification().withObjectName(String.valueOf(rn.getObjectName())).withRelationId(rn.getRelationId()).withRelationTypeName(rn.getRelationTypeName()).withRoleName(rn.getRoleName());
            if (rn.getNewRoleValue() != null) {
                ont = this.toObjectNamesType(rn.getNewRoleValue());
                ((RelationNotification)jaxb).withNewRoleValue(ont);
            }
            if (rn.getOldRoleValue() != null) {
                ont = this.toObjectNamesType(rn.getOldRoleValue());
                ((RelationNotification)jaxb).withOldRoleValue(ont);
            }
            if (rn.getMBeansToUnregister() != null) {
                ont = this.toObjectNamesType(rn.getMBeansToUnregister());
                ((RelationNotification)jaxb).withMBeansToUnregister(ont);
            }
        } else if (aNotification instanceof TimerNotification) {
            jaxb = this.mObjectFactory.createTimerNotification().withNotificationId(((TimerNotification)aNotification).getNotificationID());
        } else {
            jaxb = this.mObjectFactory.createNotificationEventType();
            wrap = true;
        }
        jaxb.withMessage(aNotification.getMessage()).withSequence(aNotification.getSequenceNumber()).withSource(String.valueOf(aNotification.getSource())).withTimestamp(aNotification.getTimeStamp()).withType(aNotification.getType());
        if (aNotification.getUserData() != null) {
            jaxb.withUserData(String.valueOf(aNotification.getUserData()));
        }
        try {
            DatatypeFactory df = this.getDatatypeFactory();
            Date date = new Date(aNotification.getTimeStamp());
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(date);
            jaxb.withDateTime(df.newXMLGregorianCalendar(gc));
            NotificationEventType bean = wrap ? this.mObjectFactory.createNotificationEvent(jaxb) : jaxb;
            StringWriter sw = new StringWriter();
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.marshal((Object)bean, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new NotificationFormatException((Exception)((Object)e));
        }
        catch (DatatypeConfigurationException e) {
            throw new NotificationFormatException(e);
        }
    }

    private ObjectNamesType toObjectNamesType(List<ObjectName> objectNameList) {
        List<String> roles = this.toStringList(objectNameList);
        ObjectNamesType ont = this.mObjectFactory.createObjectNamesType();
        ont.withObjectName(roles);
        return ont;
    }

    private DatatypeFactory getDatatypeFactory() throws DatatypeConfigurationException {
        if (this.mDatatypeFactory == null) {
            this.mDatatypeFactory = DatatypeFactory.newInstance();
        }
        return this.mDatatypeFactory;
    }

    private List<String> toStringList(List<ObjectName> objectNames) {
        ArrayList<String> roles = new ArrayList<String>(objectNames.size());
        for (ObjectName on : objectNames) {
            roles.add(on.toString());
        }
        return roles;
    }

    protected JAXBContext createContext(String contextPath) throws JAXBException {
        ClassLoader cl = NotificationXmlFormatter.class.getClassLoader();
        try {
            LOG.info("Creating JAXBContext with contextPath: " + contextPath + " and classloader: " + cl);
            return JAXBContext.newInstance((String)contextPath, (ClassLoader)cl);
        }
        catch (Exception e) {
            LOG.info("Creating JAXBContext with contextPath: {}", (Object)contextPath);
            return JAXBContext.newInstance((String)contextPath);
        }
    }

    protected void doStart() throws Exception {
        this.jaxbContext = this.createContext("org.apache.camel.component.jmx.jaxb");
    }

    protected void doStop() throws Exception {
    }
}

