/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.johnzon;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperBuilder;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JohnzonDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(JohnzonDataFormat.class);
    private CamelContext camelContext;
    private Mapper objectMapper;
    private Class<?> unmarshalType;
    private JohnzonParameterizedType parameterizedType;
    private Comparator<String> attributeOrder;
    private boolean pretty;
    private String encoding;
    private boolean skipEmptyArray;
    private boolean skipNull;

    public JohnzonDataFormat() {
        this(Object.class);
    }

    public JohnzonDataFormat(Class<?> unmarshalType) {
        this(null, unmarshalType);
    }

    public JohnzonDataFormat(JohnzonParameterizedType parameterizedType) {
        this(null, parameterizedType);
    }

    public JohnzonDataFormat(Mapper mapper, Class<?> unmarshalType) {
        this.objectMapper = mapper;
        this.unmarshalType = unmarshalType;
    }

    public JohnzonDataFormat(Mapper mapper, JohnzonParameterizedType parameterizedType) {
        this.objectMapper = mapper;
        this.parameterizedType = parameterizedType;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public String getDataFormatName() {
        return "json-johnzon";
    }

    public Mapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(Mapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public JohnzonParameterizedType getParameterizedType() {
        return this.parameterizedType;
    }

    public void setParameterizedType(JohnzonParameterizedType parameterizedType) {
        this.parameterizedType = parameterizedType;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isSkipEmptyArray() {
        return this.skipEmptyArray;
    }

    public void setSkipEmptyArray(boolean skipEmptyArray) {
        this.skipEmptyArray = skipEmptyArray;
    }

    public boolean isSkipNull() {
        return this.skipNull;
    }

    public void setSkipNull(boolean skipNull) {
        this.skipNull = skipNull;
    }

    public Comparator<String> getAttributeOrder() {
        return this.attributeOrder;
    }

    public void setAttributeOrder(Comparator<String> attributeOrder) {
        this.attributeOrder = attributeOrder;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        this.objectMapper.writeObject(graph, stream);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        Class clazz = this.unmarshalType;
        String type = (String)exchange.getIn().getHeader("CamelJohnzonUnmarshalType", String.class);
        if (type != null) {
            clazz = exchange.getContext().getClassResolver().resolveMandatoryClass(type);
        }
        if (this.parameterizedType != null) {
            return this.objectMapper.readCollection(stream, (ParameterizedType)this.parameterizedType);
        }
        return this.objectMapper.readObject(stream, (Type)clazz);
    }

    protected void doStart() throws Exception {
        if (this.objectMapper == null) {
            MapperBuilder builder = new MapperBuilder();
            builder.setPretty(this.pretty);
            builder.setSkipNull(this.skipNull);
            builder.setSkipEmptyArray(this.skipEmptyArray);
            if (ObjectHelper.isNotEmpty((Object)this.encoding)) {
                builder.setEncoding(this.encoding);
            }
            if (ObjectHelper.isNotEmpty(this.attributeOrder)) {
                builder.setAttributeOrder(this.attributeOrder);
            }
            this.objectMapper = builder.build();
        }
    }

    protected void doStop() throws Exception {
    }
}

