/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.jq;

import java.lang.annotation.Annotation;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.language.jq.Jq;
import org.apache.camel.language.jq.JqExpression;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.language.DefaultAnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;
import org.apache.camel.util.ObjectHelper;

public class JqAnnotationExpressionFactory
extends DefaultAnnotationExpressionFactory {
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        String expression = this.getExpressionFromAnnotation(annotation);
        JqExpression answer = new JqExpression(expression);
        Class<?> resultType = this.getResultType(annotation);
        if (resultType.equals(Object.class)) {
            resultType = expressionReturnType;
        }
        if (resultType != null) {
            answer.setResultType(resultType);
        }
        if (annotation instanceof Jq) {
            Jq jqAnnotation = (Jq)annotation;
            String variableName = null;
            String headerName = null;
            String propertyName = null;
            if (ObjectHelper.isNotEmpty((String)jqAnnotation.variableName())) {
                variableName = jqAnnotation.variableName();
            }
            if (ObjectHelper.isNotEmpty((String)jqAnnotation.headerName())) {
                headerName = jqAnnotation.headerName();
            }
            if (ObjectHelper.isNotEmpty((String)jqAnnotation.propertyName())) {
                propertyName = jqAnnotation.propertyName();
            }
            if (variableName != null || headerName != null || propertyName != null) {
                answer.setSource(ExpressionBuilder.singleInputExpression((String)variableName, (String)headerName, (String)propertyName));
            }
        }
        answer.init(camelContext);
        return answer;
    }

    private Class<?> getResultType(Annotation annotation) {
        return (Class)this.getAnnotationObjectValue(annotation, "resultType");
    }
}

