/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonvalidator;

import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationMessage;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.ValidationException;

public class JsonValidationException
extends ValidationException {
    private static final long serialVersionUID = 1L;
    private final JsonSchema schema;
    private final Set<ValidationMessage> errors;

    public JsonValidationException(Exchange exchange, JsonSchema schema, Set<ValidationMessage> errors) {
        super(exchange, "JSON validation error with " + errors.size() + " errors:\n" + JsonValidationException.toString(errors));
        this.schema = schema;
        this.errors = errors;
    }

    public JsonValidationException(Exchange exchange, JsonSchema schema, Exception e) {
        super(e.getMessage(), exchange, (Throwable)e);
        this.schema = schema;
        this.errors = null;
    }

    public JsonSchema getSchema() {
        return this.schema;
    }

    public Set<ValidationMessage> getErrors() {
        return this.errors;
    }

    public int getNumberOfErrors() {
        return this.errors.size();
    }

    private static String toString(Set<ValidationMessage> errors) {
        return errors.stream().map(ValidationMessage::toString).collect(Collectors.joining("\n"));
    }
}

