/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jta;

import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.jta.JtaTransactionErrorHandlerReifier;
import org.apache.camel.jta.JtaTransactionPolicy;
import org.apache.camel.jta.TransactionErrorHandler;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.CamelLogger;
import org.slf4j.LoggerFactory;

public class JtaTransactionErrorHandlerBuilder
extends DefaultErrorHandlerBuilder {
    private LoggingLevel rollbackLoggingLevel = LoggingLevel.WARN;
    private JtaTransactionPolicy transactionPolicy;
    private String policyRef;

    public boolean supportTransacted() {
        return true;
    }

    public ErrorHandlerBuilder cloneBuilder() {
        JtaTransactionErrorHandlerBuilder answer = new JtaTransactionErrorHandlerBuilder();
        this.cloneBuilder(answer);
        return answer;
    }

    protected void cloneBuilder(DefaultErrorHandlerBuilder other) {
        super.cloneBuilder(other);
        if (other instanceof JtaTransactionErrorHandlerBuilder) {
            JtaTransactionErrorHandlerBuilder otherTx = (JtaTransactionErrorHandlerBuilder)other;
            this.transactionPolicy = otherTx.transactionPolicy;
            this.rollbackLoggingLevel = otherTx.rollbackLoggingLevel;
        }
    }

    public String getPolicyRef() {
        return this.policyRef;
    }

    public JtaTransactionErrorHandlerBuilder setTransactionPolicy(String ref) {
        this.policyRef = ref;
        return this;
    }

    public JtaTransactionPolicy getTransactionPolicy() {
        return this.transactionPolicy;
    }

    public JtaTransactionErrorHandlerBuilder setTransactionPolicy(JtaTransactionPolicy transactionPolicy) {
        this.transactionPolicy = transactionPolicy;
        return this;
    }

    public LoggingLevel getRollbackLoggingLevel() {
        return this.rollbackLoggingLevel;
    }

    public JtaTransactionErrorHandlerBuilder setRollbackLoggingLevel(LoggingLevel rollbackLoggingLevel) {
        this.rollbackLoggingLevel = rollbackLoggingLevel;
        return this;
    }

    protected CamelLogger createLogger() {
        return new CamelLogger(LoggerFactory.getLogger(TransactionErrorHandler.class), LoggingLevel.ERROR);
    }

    public String toString() {
        return "JtaTransactionErrorHandlerBuilder";
    }

    static {
        ErrorHandlerReifier.registerReifier(JtaTransactionErrorHandlerBuilder.class, JtaTransactionErrorHandlerReifier::new);
    }
}

