/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jte;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import java.nio.file.Path;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jte.JteCodeResolver;
import org.apache.camel.component.jte.JteEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="jte")
public class JteComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(JteComponent.class);
    private JteCodeResolver codeResolver;
    private TemplateEngine templateEngine;
    @Metadata(defaultValue="jte-classes")
    private String workDir = "jte-classes";
    @Metadata
    private boolean preCompile;
    @Metadata(defaultValue="Plain")
    private ContentType contentType = ContentType.Plain;
    @Metadata
    private boolean allowTemplateFromHeader;
    @Metadata
    private boolean allowContextMapAll;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JteEndpoint endpoint = new JteEndpoint(uri, (Component)this, remaining);
        endpoint.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        endpoint.setAllowContextMapAll(this.allowContextMapAll);
        this.setProperties((Endpoint)endpoint, parameters);
        if (ResourceHelper.isHttpUri((String)remaining)) {
            remaining = ResourceHelper.appendParameters((String)remaining, parameters);
            endpoint.setResourceUri(remaining);
        }
        return endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        Path dir = Path.of(this.workDir, new String[0]);
        if (this.preCompile) {
            LOG.info("Using pre-compiling JTE templates: {}", (Object)this.workDir);
            this.templateEngine = TemplateEngine.createPrecompiled((Path)dir, (ContentType)this.contentType, (ClassLoader)this.getCamelContext().getApplicationContextClassLoader());
        } else {
            LOG.info("Using runtime compiled JTE templates: {}", (Object)this.workDir);
            this.codeResolver = new JteCodeResolver(this.getCamelContext());
            this.templateEngine = TemplateEngine.create((CodeResolver)this.codeResolver, (Path)dir, (ContentType)this.contentType, (ClassLoader)this.getCamelContext().getApplicationContextClassLoader());
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.templateEngine != null) {
            this.templateEngine.cleanAll();
        }
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public JteCodeResolver getCodeResolver() {
        return this.codeResolver;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public boolean isPreCompile() {
        return this.preCompile;
    }

    public void setPreCompile(boolean preCompile) {
        this.preCompile = preCompile;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public boolean isAllowContextMapAll() {
        return this.allowContextMapAll;
    }

    public void setAllowContextMapAll(boolean allowContextMapAll) {
        this.allowContextMapAll = allowContextMapAll;
    }
}

