/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jte;

import gg.jte.CodeResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.util.IOHelper;

public class JteCodeResolver
implements CodeResolver {
    private final CamelContext camelContext;
    private final Map<String, String> headerTemplates = new ConcurrentHashMap<String, String>();

    public JteCodeResolver(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void addTemplateFromHeader(String exchangeId, String template) {
        if (exchangeId != null && template != null) {
            this.headerTemplates.put(exchangeId, template);
        }
    }

    public String resolve(String name) {
        InputStream is;
        String answer = this.headerTemplates.remove(name);
        if (answer == null && (is = this.camelContext.getClassResolver().loadResourceAsStream(name)) != null) {
            try {
                answer = IOHelper.loadText((InputStream)is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return answer;
    }

    public long getLastModified(String name) {
        return 0L;
    }
}

