/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.juel;

import de.odysseus.el.util.SimpleContext;
import java.util.Properties;
import javax.el.ArrayELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.ExpressionSupport;
import org.apache.camel.language.juel.BeanAndMethodELResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuelExpression
extends ExpressionSupport {
    private final String expression;
    private final Class<?> type;
    private ExpressionFactory expressionFactory;
    private Properties expressionFactoryProperties;

    public JuelExpression(String expression, Class<?> type) {
        this.expression = expression;
        this.type = type;
    }

    public static JuelExpression el(String expression) {
        return new JuelExpression(expression, Object.class);
    }

    public <T> T evaluate(Exchange exchange, Class<T> tClass) {
        ELContext context = this.populateContext(this.createContext(), exchange);
        ValueExpression valueExpression = this.getExpressionFactory().createValueExpression(context, this.expression, this.type);
        Object value = valueExpression.getValue(context);
        return (T)exchange.getContext().getTypeConverter().convertTo(tClass, value);
    }

    public ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            Properties properties = this.getExpressionFactoryProperties();
            this.expressionFactory = ExpressionFactory.newInstance((Properties)properties);
        }
        return this.expressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public Properties getExpressionFactoryProperties() {
        if (this.expressionFactoryProperties == null) {
            this.expressionFactoryProperties = new Properties();
            this.populateDefaultExpressionProperties(this.expressionFactoryProperties);
        }
        return this.expressionFactoryProperties;
    }

    public void setExpressionFactoryProperties(Properties expressionFactoryProperties) {
        this.expressionFactoryProperties = expressionFactoryProperties;
    }

    protected ELContext populateContext(ELContext context, Exchange exchange) {
        this.setVariable(context, "exchange", exchange, Exchange.class);
        this.setVariable(context, "in", exchange.getIn(), Message.class);
        if (exchange.hasOut()) {
            this.setVariable(context, "out", exchange.getOut(), Message.class);
        }
        return context;
    }

    protected void populateDefaultExpressionProperties(Properties properties) {
        properties.setProperty("javax.el.methodInvocations", "true");
    }

    protected void setVariable(ELContext context, String name, Object value, Class<?> type) {
        ValueExpression valueExpression = this.getExpressionFactory().createValueExpression(value, type);
        SimpleContext simpleContext = (SimpleContext)context;
        simpleContext.setVariable(name, valueExpression);
    }

    protected ELContext createContext() {
        CompositeELResolver resolver = new CompositeELResolver(){
            {
                this.add((ELResolver)new ArrayELResolver(false));
                this.add((ELResolver)new ListELResolver(false));
                this.add((ELResolver)new MapELResolver(false));
                this.add((ELResolver)new ResourceBundleELResolver());
                this.add((ELResolver)new BeanAndMethodELResolver());
            }
        };
        return new SimpleContext((ELResolver)resolver);
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expression;
    }
}

