/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import org.apache.camel.component.kafka.KafkaManualCommit;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;

public abstract class DefaultKafkaManualCommit
implements KafkaManualCommit {
    private final Consumer consumer;
    private final String topicName;
    private final String threadId;
    private final StateRepository<String, String> offsetRepository;
    private final TopicPartition partition;
    private final long recordOffset;
    private final long commitTimeout;

    public DefaultKafkaManualCommit(Consumer consumer, String topicName, String threadId, StateRepository<String, String> offsetRepository, TopicPartition partition, long recordOffset, long commitTimeout) {
        this.consumer = consumer;
        this.topicName = topicName;
        this.threadId = threadId;
        this.offsetRepository = offsetRepository;
        this.partition = partition;
        this.recordOffset = recordOffset;
        this.commitTimeout = commitTimeout;
    }

    @Override
    public void commitSync() {
        throw new IllegalStateException("This method is deprecated and should not be used anymore.");
    }

    protected String serializeOffsetKey(TopicPartition topicPartition) {
        return topicPartition.topic() + '/' + topicPartition.partition();
    }

    protected String serializeOffsetValue(long offset) {
        return String.valueOf(offset);
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public StateRepository<String, String> getOffsetRepository() {
        return this.offsetRepository;
    }

    public TopicPartition getPartition() {
        return this.partition;
    }

    public long getRecordOffset() {
        return this.recordOffset;
    }

    public long getCommitTimeout() {
        return this.commitTimeout;
    }
}

