/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.component.kafka.KafkaComponent;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.KafkaManualCommitFactory;
import org.apache.camel.component.kafka.KafkaProducer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.SynchronousDelegateProducer;
import org.apache.camel.util.CastUtils;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.13.0", scheme="kafka", title="Kafka", syntax="kafka:topic", category={Category.MESSAGING})
public class KafkaEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaEndpoint.class);
    private static final String CALLBACK_HANDLER_CLASS_CONFIG = "sasl.login.callback.handler.class";
    @UriParam
    private KafkaConfiguration configuration = new KafkaConfiguration();
    @UriParam(label="advanced")
    private KafkaClientFactory kafkaClientFactory;
    @UriParam(label="consumer,advanced")
    private KafkaManualCommitFactory kafkaManualCommitFactory;

    public KafkaEndpoint() {
    }

    public KafkaEndpoint(String endpointUri, KafkaComponent component) {
        super(endpointUri, (Component)component);
    }

    public KafkaComponent getComponent() {
        return (KafkaComponent)super.getComponent();
    }

    public KafkaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KafkaConfiguration configuration) {
        this.configuration = configuration;
    }

    public KafkaClientFactory getKafkaClientFactory() {
        return this.kafkaClientFactory;
    }

    public void setKafkaClientFactory(KafkaClientFactory kafkaClientFactory) {
        this.kafkaClientFactory = kafkaClientFactory;
    }

    public KafkaManualCommitFactory getKafkaManualCommitFactory() {
        return this.kafkaManualCommitFactory;
    }

    public void setKafkaManualCommitFactory(KafkaManualCommitFactory kafkaManualCommitFactory) {
        this.kafkaManualCommitFactory = kafkaManualCommitFactory;
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        if (this.kafkaClientFactory == null) {
            this.kafkaClientFactory = this.getComponent().getKafkaClientFactory();
        }
        if (this.kafkaManualCommitFactory == null) {
            this.kafkaManualCommitFactory = this.getComponent().getKafkaManualCommitFactory();
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        KafkaConsumer consumer = new KafkaConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        KafkaProducer producer = this.createProducer(this);
        if (this.getConfiguration().isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)producer);
        }
        return producer;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    <T> Class<T> loadClass(Object o, ClassResolver resolver, Class<T> type) {
        if (o == null || o instanceof Class) {
            return CastUtils.cast((Class)((Class)o));
        }
        String name = o.toString();
        Class c = resolver.resolveClass(name, type);
        if (c == null) {
            c = resolver.resolveClass(name, type, ((Object)((Object)this)).getClass().getClassLoader());
        }
        if (c == null) {
            c = resolver.resolveClass(name, type, org.apache.kafka.clients.producer.KafkaProducer.class.getClassLoader());
        }
        return c;
    }

    void replaceWithClass(Properties props, String key, ClassResolver resolver, Class<?> type) {
        Class<?> c = this.loadClass(props.get(key), resolver, type);
        if (c != null) {
            props.put(key, c);
        }
    }

    public void updateClassProperties(Properties props) {
        try {
            if (this.getCamelContext() != null) {
                ClassResolver resolver = this.getCamelContext().getClassResolver();
                this.replaceWithClass(props, "key.serializer", resolver, Serializer.class);
                this.replaceWithClass(props, "value.serializer", resolver, Serializer.class);
                this.replaceWithClass(props, "partitioner.class", resolver, Partitioner.class);
                this.replaceWithClass(props, "key.deserializer", resolver, Deserializer.class);
                this.replaceWithClass(props, "value.deserializer", resolver, Deserializer.class);
                this.replaceWithClass(props, CALLBACK_HANDLER_CLASS_CONFIG, resolver, AuthenticateCallbackHandler.class);
            }
        }
        catch (Exception t) {
            LOG.debug("Problem loading classes for Serializers", (Throwable)t);
        }
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "KafkaConsumer[" + this.configuration.getTopic() + "]", this.configuration.getConsumersCount());
    }

    public ExecutorService createProducerExecutor() {
        int core = this.getConfiguration().getWorkerPoolCoreSize();
        int max = this.getConfiguration().getWorkerPoolMaxSize();
        return this.getCamelContext().getExecutorServiceManager().newThreadPool((Object)this, "KafkaProducer[" + this.configuration.getTopic() + "]", core, max);
    }

    protected KafkaProducer createProducer(KafkaEndpoint endpoint) {
        return new KafkaProducer(endpoint);
    }
}

