/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.serde;

import java.nio.ByteBuffer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.component.kafka.serde.KafkaHeaderSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKafkaHeaderSerializer
implements KafkaHeaderSerializer,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKafkaHeaderSerializer.class);
    private CamelContext camelContext;

    @Override
    public byte[] serialize(String key, Object value) {
        byte[] converted;
        if (value instanceof String) {
            String string = (String)value;
            return string.getBytes();
        }
        if (value instanceof Long) {
            Long aLong = (Long)value;
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(aLong);
            return buffer.array();
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(integer);
            return buffer.array();
        }
        if (value instanceof Double) {
            Double aDouble = (Double)value;
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putDouble(aDouble);
            return buffer.array();
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b.toString().getBytes();
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return bytes;
        }
        if (this.camelContext != null && (converted = (byte[])this.camelContext.getTypeConverter().tryConvertTo(byte[].class, value)) != null) {
            return converted;
        }
        LOG.debug("Cannot propagate header value of type[{}], skipping... Supported types: String, Integer, Long, Double, byte[].", value != null ? value.getClass() : "null");
        return null;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

