/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.console;

import java.util.Map;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="dependency-downloader")
public class DependencyDownloaderConsole
extends AbstractDevConsole {
    public DependencyDownloaderConsole() {
        super("jvm", "dependency-downloader", "Maven Dependency Downloader", "Displays information about dependencies downloaded at runtime");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        ClassLoader cl = this.getCamelContext().getApplicationContextClassLoader();
        if (cl instanceof DependencyDownloaderClassLoader) {
            DependencyDownloaderClassLoader ddcl = (DependencyDownloaderClassLoader)cl;
            sb.append("Dependencies:");
            String cp = String.join((CharSequence)"\n    ", ddcl.getDownloaded());
            sb.append("\n    ").append(cp).append("\n");
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ClassLoader cl = this.getCamelContext().getApplicationContextClassLoader();
        if (cl instanceof DependencyDownloaderClassLoader) {
            DependencyDownloaderClassLoader ddcl = (DependencyDownloaderClassLoader)cl;
            String[] cp = ddcl.getDownloaded().toArray(new String[0]);
            root.put((Object)"dependencies", (Object)cp);
        }
        return root;
    }
}

